/* From input file "JUGGLE.text" */
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>

#include "p2c.h"

/* Written by Allen Knutson [ALLENK]        6/88              Da So Ma.*/
/*  Things to be added:*/
/*      Several patterns listed on screen, with switching between them.*/
/*      Integrate the pattern maker LISTALLP that's in /src/games.*/
/* */
/*Notes:*/
/*         I'm assuming that hold time = time of a 1-throw; theta = 1/2.*/
/*         Thus n-throw + hold time =   n      * (1-throw + hold time),*/
/*                                             as n-throws are defined,*/
/*              n-throw             = (2n-1)   *  1-throw.*/
/*         Thus n-throw height      = (2n-1)^2 *  1-throw height,*/
/*                                   inducing the calculation above.     */

/* #define long int */

#define BITBLT 

typedef struct ball {
    short handfrom;
    short throw;
    short lateral;
    long ox, oy, x, y;
#ifdef BITBLT
    void far *bitmap;
#endif
} ball;

typedef struct worldvar {
    char title[256];
    long *vptr, new_;
    boolean bounded;
    long lower, upper;
    boolean scaledep;
    long step;
    boolean slow;
    long default_;
} worldvar;

#define KLUDGE          100

/* to reduce roundoff error from DIVs */
#define KNOB            5

/* how much to change 'playing with..' */
#define NUMOPTIONS      6

static int M_DOWN, M_ACROSS;
static worldvar fiddle[NUMOPTIONS + 1];
static ball world[61];
static long pat[121];
static long m, c, scale, i, j, detail; 
static boolean done;
static long ticks, thrownow, throwsnow;
static boolean emptyhand;
static long sum;
static boolean diagnos;
static long howfar, xbase, ybase, disp;
static int ch;
static long center, width, sideways, current, highest, throwfactor;
static boolean onacid;
static long playing, height, patst, patfin, now, prehighest, ballsize;

#define M_XOR 1
#define M_NORMAL 1
#define m_colormode(a) a

static void redo_screen(void)
{
    int k, FORLIM;
    ball *WITH;

    clrscr();
    cleardevice();
    m_colormode((long)M_XOR);
    FORLIM = m;
    for (k = 1; k <= FORLIM; k++) {
        WITH = &world[k];
        WITH->x = -ballsize * 2;
        WITH->y = WITH->x;
        WITH->ox = WITH->x;
        WITH->oy = WITH->x;
    }
}

static void fiddle_around(void)
{
	int outdated, change;
	boolean changed;
	worldvar *WITH;

	ch = getch();
	switch (ch) {
		case '!':
			system("");
			redo_screen();
			break;
		case 'a':
		case 'A':
			onacid = 1;
			m_colormode((long)M_NORMAL);
			break;
		case 's':
		case 'S':
			redo_screen();
			onacid = 0;
			m_colormode((long)M_XOR);
			break;
		case 't':
		case 'T':
		case '+':
		case '-':
		case 'f':
		case 'F':
		case 0:
			if (ch == 0) ch = getch() * 10;
			if (ch == 't' || ch == 800) playing += KNOB;
			if (ch == 'T' || ch == 720) playing -= KNOB;
			outdated = current;
			current = (current + NUMOPTIONS + playing / KNOB) % NUMOPTIONS;
			if (playing <= -KNOB) playing += KNOB;
			if (playing >= KNOB) playing -= KNOB;
			if (outdated != current) {
#if 0
				gotoxy(1, outdated + 2);
				printf("%s%5ld", fiddle[outdated].title, *fiddle[outdated].vptr);
				gotoxy(1, current + 2);
				printf("%s%5ld", fiddle[current].title, *fiddle[current].vptr);
#endif
				gotoxy(1, 1);
				printf("                         ");
				gotoxy(1, 1);
				printf("%s%5ld", fiddle[current].title, *fiddle[current].vptr);
			}
			WITH = &fiddle[current];
			if (!WITH->slow) WITH->new_ = *WITH->vptr;
			changed = 0;
			if (ch == '+' || ch == '-' || ch == 750 || ch == 770) {
				change = WITH->step;
				if (ch == '-' || ch == 750) change = -change; 
				if (!WITH->slow) WITH->new_ = *WITH->vptr;
				if (!WITH->bounded || WITH->new_ + change >= WITH->lower && 
					WITH->new_ + change <= WITH->upper)
						WITH->new_ += change;
				changed = 1;
			}
			if (ch == 'f' || ch == 'F') {
				WITH->new_ = WITH->default_;
				changed = 1;
			}
			if (changed) {
				if (!WITH->slow) *WITH->vptr = WITH->new_;
				/* gotoxy(1, current + 2); */
				gotoxy(1, 1);
				printf("%s%5ld", WITH->title, WITH->new_);
				if (WITH->scaledep)
					scale = KLUDGE*(height-((sideways < 0) ? -sideways : sideways)
						* 2 - ballsize * 3) / ((highest*2 - 1) * (highest*2 - 1));
			}
			break;
		case 'q':
		case 'Q':
			done = 1;
			break;
		default:
			gotoxy(1, 1);
			printf("Unknown command %d\n",ch);
	}
}

static void setupgraphics(void)
{
	 int g_driver, g_mode, g_error;

	 detectgraph(&g_driver,&g_mode);
	 if (g_driver < 0) {
		 printf("no graphics!\n");
		 exit(-1);
	 }
	 printf("found graphics driver #%d, mode #%d\n",g_driver,g_mode);
	 initgraph(&g_driver,&g_mode,NULL);
	 g_error = graphresult();
	 if (g_error < 0) {
		 printf("Initgraph error: %s\n",grapherrormsg(g_error));
		 closegraph();
		 exit(-1);
	 }
	 setbkcolor(BLACK);
}

static void setup(void)
{
    long i, FORLIM;
    worldvar *WITH;

    printf("%ld balls in the", m);
    FORLIM = c - 1;
    for (i = 0; i <= FORLIM; i++)
        printf(" %ld", pat[i + 60]);
    printf(" pattern.\n");

    WITH = fiddle;
    strcpy(WITH->title, "Detail    ");
    WITH->vptr = &detail;
    WITH->new_ = detail;
    WITH->bounded = 1;
    WITH->lower = 1;
    WITH->upper = M_DOWN / m; 
    WITH->scaledep = 0;
    WITH->step = 1;
    WITH->slow = 1;
    WITH->default_ = detail;
    WITH = &fiddle[1];
    strcpy(WITH->title, "Center    ");
    WITH->vptr = &center;
    WITH->bounded = 0;
    WITH->scaledep = 0;
    WITH->step = 10;
    WITH->slow = 0;
    WITH->default_ = center;
    WITH = &fiddle[2];
    strcpy(WITH->title, "Wingspan  ");
    WITH->vptr = &width;
    WITH->bounded = 0;
    WITH->scaledep = 0;
    WITH->step = 5;
    WITH->slow = 0;
    WITH->default_ = width;
    WITH = &fiddle[3];
    strcpy(WITH->title, "Clumsiness");
    WITH->vptr = &sideways;
    WITH->bounded = 0;
    WITH->scaledep = 1;
    WITH->step = 5;
    WITH->slow = 0;
    WITH->default_ = sideways;
    WITH = &fiddle[4];
    strcpy(WITH->title, "Height    ");
    WITH->vptr = &height;
    WITH->bounded = 1;
    WITH->upper = M_DOWN - 9;
    WITH->lower = sideways * 2 + 9;
    WITH->scaledep = 1;
    WITH->step = 5;
    WITH->slow = 0;
    WITH->default_ = height;
    WITH = &fiddle[5];
    strcpy(WITH->title, "Ballsize  ");
    WITH->vptr = &ballsize;
    WITH->new_ = ballsize;
    WITH->bounded = 1;
    WITH->upper = 100;
    WITH->lower = 1;
    WITH->scaledep = 1;
    WITH->step = 1;
    WITH->slow = 1;
    WITH->default_ = ballsize;
/*
    for (i = 0; i < NUMOPTIONS; i++) {
        gotoxy(1, i + 3);
        printf("%s%5ld", fiddle[i].title, *fiddle[i].vptr);
    }
*/
    current = 0;

	cleardevice();
#ifdef BITBLT
	/* setup bitblt images */
	for (i = 1; i <= m; i++) {
		setcolor(((i - 1) & 7) + 1); /* draw a ball */
		setfillstyle(SOLID_FILL,((i-1) & 7) + 1);
		pieslice(ballsize,ballsize, 0, 360, ballsize);
		world[i].bitmap= malloc(imagesize(0,0,2*ballsize,2*ballsize));
		getimage(0,0,2*ballsize,2*ballsize,world[i].bitmap);
	}
#endif

}

#define strtol(a,b,c) atoi(a)
main(int argc, char *argv[])
{
	long FORLIM;
	ball *WITH;
	long FORLIM1;
	worldvar *WITH1;

	if (argc == 1) {
		printf("Usage: juggle [-d] <pattern> [-s <pattern>]\n");
		exit(-1);
	}
	setupgraphics();
	M_ACROSS = getmaxx();
	M_DOWN = getmaxy() - 10; /* need some space for bitblt images */
	center = M_ACROSS / 2;
	width = M_ACROSS / 8;
	sideways = 25;
	height = M_DOWN - 9;
	ballsize = 5;
	current = -1;
	detail = M_DOWN;
	sum = 0;
	done = 0;
	patst = 1;
	diagnos = !strcmp(argv[1], "-d");
	patfin = argc - 1;
	if (diagnos)
		patst = 2;
	for (i = argc - 1; i >= 1; i--) 
		if (!strcmp(argv[i], "-s")) patfin = i - 1;
	highest = 0;
	FORLIM = patfin;
	for (i = patst; i <= FORLIM; i++) {
		pat[i + 59] = strtol(argv[i], NULL, 0);
		sum += pat[i + 59];
		if (pat[i + 59] > highest)
			highest = pat[i + 59];
	}
	ticks = 0;
	prehighest = highest;
	if (patfin <= argc - 3) {
		FORLIM = argc - 1;
		for (i = patfin + 2; i <= FORLIM; i++) {
			pat[i - argc + 60] = strtol(argv[i], NULL, 0);
			if (pat[i - argc + 60] > prehighest)
				prehighest = pat[i - argc + 60];
		}
		ticks = (patfin - argc + 2) * 2;
	}
	height = sideways * 2 + ballsize * 3 + 
		(height - sideways * 2 - ballsize * 3) * (highest * 2 - 1) * 
		(highest	* 2 - 1) / ((prehighest * 2 - 1) * (prehighest * 2 - 1));
	diagnos = 0;
	c = patfin - patst + 1;
	m = sum / c;

	detail /= m * 5;
 	setup(); 
	scale = KLUDGE * (height - ((sideways < 0) ? -sideways : sideways) * 2 -
		ballsize * 3) / ((highest * 2 - 1) * (highest * 2 - 1));
	world[0].handfrom = 1;
	FORLIM = m;
	for (i = 1; i <= FORLIM; i++) {
		WITH = &world[i];
		WITH->handfrom = -world[i - 1].handfrom;
		WITH->lateral = (i - m) * 2;
		WITH->throw = -1;
	}
	redo_screen();
/*			m_choosecolors(1L); */
	onacid = 0;
	while (!done) {
		now = ticks / 2;
		if (now >= c)
			now -= c;
		thrownow = pat[now + 60];
		throwsnow = 0;
		emptyhand = 0;
		FORLIM = m;
		for (i = 1; i <= FORLIM; i++) {
			WITH = &world[i];
			switch (WITH->throw) {
				case -2:
					printf("Can't drop them yet\n");
					break;
				case -1:
					if (WITH->lateral < 0) ++WITH->lateral;
					else {
						WITH->lateral = 1;
						WITH->throw = thrownow;
						++throwsnow;
						WITH->handfrom = (ticks & 3) - 1;
					}
					break;
				case 0:
					emptyhand = 1;
					break;
				default:
					if (WITH->lateral < WITH->throw * 2) ++WITH->lateral;
					else {
						WITH->lateral = 1;
						WITH->throw = thrownow;
						++throwsnow;
						WITH->handfrom = (ticks & 3) - 1;
					}
			} /* switch */
		}
		FORLIM = detail - 1;
		for (j = 0; j <= FORLIM; j++) {
			FORLIM1 = m;
			for (i = 1; i <= FORLIM1; i++) {
				setcolor((i - 1 & 7) + 1);
				if (!done) {
					WITH = &world[i];
					if (kbhit())
						fiddle_around();
					WITH->ox = WITH->x;
					WITH->oy = WITH->y;
					xbase = center + WITH->handfrom * (width - sideways);
					ybase = ((sideways < 0) ? -sideways : sideways) * 2 + ballsize;
					howfar = (WITH->lateral - 1) * detail + j;
					throwfactor = WITH->throw * 2 - 1;
					if (WITH->throw > 0) {
						if ((WITH->throw & 1) == 1)
							disp = -width;
						else
							disp = sideways;
						if (WITH->lateral == WITH->throw * 2) {
							disp = sideways * ((WITH->throw & 1) * 2 - 1);
							xbase = center + WITH->handfrom * (width + sideways)
								* (1 - (WITH->throw & 1) * 2);
							howfar = throwfactor * j;
						}
						if (WITH->throw == 2) {
							howfar = 0;
							xbase = center + WITH->handfrom * (width - sideways);
						}
						WITH->x = xbase + WITH->handfrom * howfar * disp * 2
							/ throwfactor / detail;
						WITH->y = ybase + (scale * throwfactor - scale * howfar
							/ detail) * howfar * 4 / detail / KLUDGE;
						if (WITH->lateral == WITH->throw * 2 && WITH->throw != 2)
							WITH->y = ybase - j * (detail - j) * ((sideways <
							0) ? -sideways : sideways) * 8 / (detail * detail);
					} else {
						WITH->x = center + WITH->handfrom * (width - sideways)
							* ((m & 1) * 2 - 1) + WITH->handfrom * howfar * ballsize
								* 3 / (detail * throwfactor);
						WITH->y = ybase;
					}
				}
			}
			FORLIM1 = m;
			for (i = 1; i <= FORLIM1; i++) {
				WITH = &world[i];
				if (!(WITH->x == WITH->ox && WITH->y == WITH->oy)) {
/*
setcolor((i - 1 & 7) + 1);
m_ellipse(WITH->x, WITH->y, fiddle[5].new_, fiddle[5].new_,	(i - 1) % 15 + 1);
m_ellipse(WITH->ox, WITH->oy, ballsize, ballsize, (i - 1)% 15 + 1);
*/
#ifdef BITBLT
if (!onacid) putimage(WITH->ox, M_DOWN - WITH->oy, world[i].bitmap, XOR_PUT);
putimage(WITH->x, M_DOWN - WITH->y, world[i].bitmap, COPY_PUT);
#else
setcolor(getbkcolor()); /* erase old ball */
circle(WITH->ox, M_DOWN - WITH->oy, ballsize);     /*color: (i-1)%15 + 1); */
setcolor((i - 1 & 7) + 1); /* draw new one */
circle(WITH->x, M_DOWN - WITH->y, fiddle[5].new_); /*color: (i-1)%15 + 1); */
#endif

			}
			WITH->ox = WITH->x;
			WITH->oy = WITH->y;
		}
		ballsize = fiddle[5].new_;
	}
	for (i = 0; i < NUMOPTIONS; i++) {
		WITH1 = &fiddle[i];
		if (WITH1->slow & !WITH1->scaledep)
			*WITH1->vptr = WITH1->new_;
	}
	if (!diagnos)
		gotoxy(1, 6);
	if (diagnos) {
		for (i = m; i >= 1; i--) {
			WITH = &world[i];
			printf("%2d:%2d   ", WITH->throw, WITH->lateral);
		}
	}
	if (throwsnow != (ticks + 1 & 1) && !(throwsnow == 0 && thrownow == 0))
		{
			putchar('\n');
			printf("     Bad pattern: caught %ld balls.", throwsnow);
			diagnos = 1;
		}
		if (emptyhand) {
			putchar('\n');
			printf("     Bad pattern: was holding a ball during a 0.");
			diagnos = 1;
		}
		if (diagnos)
			putchar('\n');
		++ticks;
		if (ticks == c * 4)
			ticks = 0;
	}
/*										m_graphics_off(); */
	closegraph();
	return(0);
}

/* detail, center, wingspan, clumsiness, height, ballsize */
/* juggling pattern */
/* number of balls, pattern length */
/* Height of a 1-throw */
/* How slow it is */
/* If you want to stop */
/* 1 per throw */
/* Throw to be made this tick */
/* 1 per tick iff the pattern works */
/* No hand should throw a 0-ball */
/* to count balls in CLI patterns */
/* where this ball starts */
/* half of this ball's intended displacement */
/* offset from right side */
/* each way */
/* the left hand catches at   */
/* center - width - sideways, */
/* and throws at              */
/* initialization */
/* traveling-towards-hand code */
/* There should be exactly 1 */
/* No actual ball should get a 0 */



/* End. */
