/*
 * @(#)Ball.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Ball.java,v 1.28 1997/03/26 18:53:07 mslevine Exp $
 */


/////////////////////////////////////////////////////////////////////////
class Ball extends Spriggan
{
  Thrw thrw;
  String label;
  float hue, bias, wamp, wphase, hamp, hphase;
  double width, height;
  boolean lastpath;
  
public Ball(Juggler j, Color color)
  {
    init();   // do Spriggan default initialization
    path.addPath(new Hold(new Point3(), 0, 0));
    thrw = new Thrw();
    juggler = j;
    this.color = color;
    lastpath = false;
    bias = (float)Math.random();
    hphase = (float)(3*Math.random());
    hamp = (float)Math.random();
    wphase = (float)(3*Math.random());
    wamp = (float)Math.random();
  }

public boolean move(double now)
  {
    if (juggler.controls.trippycolors.getState())
      {
	hue += (float)((Math.random()-bias)*.01);
	if (hue < (float)0.) hue += (float)1.;
	else if (hue > (float)1.) hue -= (float)1.;
	if (juggler.blackandwhite)
	  color = Color.getHSBColor((float)0., (float)0., 
				    (float)(0.33+2*hue/3));
	else
	  color = Color.getHSBColor(hue, (float)1., (float)1.);
      }
    if (juggler.controls.aliceballs.getState())
      {
	width = juggler.controls.ballscale*(1+wamp*Math.sin(now*wphase));
	height = juggler.controls.ballscale*(1+hamp*Math.sin(now*hphase));
      }
    else
      {
	width = juggler.controls.ballscale;
	height = juggler.controls.ballscale;
      }
    if (juggler.controls.numbersforballs.getState())
      {
	width *= 1.5;
	height *= 1.5;
      }
    if (path.isDone(now))
      if (lastpath) return false; 
      else juggler.taskmaster.updateBall(this);
    pos = path.interpolate(now);
    return true;
  }

public void paint(Graphics g)
  {
    g.setColor(color);
    Point center = juggler.scale.mapToPixels(pos);
    if (center.y < 0) return;
    int w = juggler.scale.scaleToPixels(width);
    int h = juggler.scale.scaleToPixels(height);
    if (w<2) w = 2;
    if (h<2) h = 2;
    if (juggler.controls.numbersforballs.getState())
      {
	// recreating the font leaks memory so be careful
	// (recreating every redraw leaks at rate of 800KBaud !!!!!)
	if (juggler.ballfont==null || 
	    Math.abs(w - juggler.ballfont.getSize()) > 2) 
	  juggler.ballfont = new Font("Helvetica", Font.PLAIN, w);
	g.setFont(juggler.ballfont);
	FontMetrics fm = g.getFontMetrics();
	g.drawString(label, center.x-fm.stringWidth(label)/2, center.y);
      }
    else
      g.fillOval(center.x-w/2, center.y-h, w, h);
  }

public Thrw thrw()
  {
    return thrw;
  }

public int logendtime()
  {
    return thrw.time;
  }


}	




