/*
 * @(#)BallSequence.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

class BallSequence extends Sequence
{
  public static boolean DBG = false;

  private boolean sync;      // if hands throw simultaneously
  boolean looping;   // if this sequence of throws can be repeated

  int numballs;      // meaningless if not looping
  int len;           // number of throws
  int timediff;      // if pattern were to loop, the number of beats
                     // between times the first throw in ths is made 
  boolean multi;     // has multiplexes
  boolean holds;     // has holds

  private int maxlen;    // amount of space allocated in ths array 
  int startt;        // logical start time of sequence
  int endt;          // logical end time of sequence (unknown until current)
		
  Thrw ths[];        // list of throws in sequence

  boolean crossingkludge; // sometimes we throw crossing evens during 
  // transitions even though we are async->async. (eg 20 -> 02) this 
  // requires that state switch parity when the new sequence starts up.
  // this variable is for the kludge that handles that

  public BallSequence()  // assume we are making default state of juggler
  {
    ths = new Thrw[2];
    ths[0] = new Thrw(0, 0, 0);
    ths[1] = new Thrw(0, 1, 0);

    looping = true;
    sync = true;    

    numballs = 0;
    len = 2;
    timediff = 2;
    maxlen = 2;

    multi = holds = true; // safer to leave these true by default

    startt = endt = 0;
    crossingkludge = false;
  }  // Sequence

  public BallSequence(int len, boolean looping)
  {
    this.looping = looping;
    sync = false;
    
    numballs = 0;
    this.len = 0;
    timediff = 0;
    maxlen = len;
    
    multi = holds = true; // safer to leave these true by default

    if(len > 0)
      ths = new Thrw[len];
    else
      ths = null;

    startt = endt = 0;
  } // Sequence

  public BallSequence copy(int newlen)
    {
      BallSequence ans = new BallSequence(newlen, this.looping);

      ans.sync = this.sync;

      ans.numballs = this.numballs;
      ans.len = newlen;
      ans.timediff = this.timediff;
      ans.maxlen = newlen;
      ans.startt = this.startt;
      ans.endt = this.endt;
      ans.multi = this.multi;
      ans.holds = this.holds;

      ans.ths = new Thrw[newlen];
      for(int i=0; i < this.len; i++)
	ans.ths[i] = this.ths[i].copy();
      return ans;
    }

  public void printSequence()
  {
    System.out.print("Printing sequence --- ");
    System.out.print("looping: "+looping+"      ");
    System.out.println("synchronous: "+sync);
  
    System.out.print("number of balls: "+numballs+"     ");
    System.out.print("length of pattern: "+len+"     ");
    System.out.print("startt: "+startt);
    System.out.println("endt: "+endt);

    System.out.println("multi: "+multi);
    System.out.println("   holds: "+holds+"        ");
    System.out.println("time difference: "+timediff);
    for(int i=0; i < len; i++)
      ths[i].printThrow();
  }  // printSequence

  public boolean isSync()
  {
    return sync;
  }
  
  public void setSync(boolean sync)
  {
    this.sync = sync;
  }  

  // note that numballs is not calculated here as it changes
  // this should be called after all throws have been added.
  public void calcParams()
  {
    if(len <= 0)
      {
	timediff = 0;
	return;
      }

    if(sync)
      timediff = ths[len-1].time + 2;
    else  
      timediff = ths[len-1].time + 1;
  }

  public int countBalls()
  {
    int tot = 0;

    if(len == 0) return 0;
    
    for(int i=0; i<len; i++)
      tot += ths[i].height;
    if (sync)
      tot /= ths[len-1].time+2;
    else
      tot /= ths[len-1].time+1;

    return tot;
  }  // countBalls

  // this only gets called when the pattern is changed, so I doubt
  // it matters that it always recomputes.  if forDisplay is true,
  // bounced throws are treated differently.   
  public int maxThrwHeight(boolean forDisplay)
  {
    int max = 0, h;

    if (ths == null) return 1;

    for (int i=0; i<len; i++) 
      {
	if (ths[i].isBou() && forDisplay == true)
	    h = ths[i].height/2;
	else h = ths[i].height;
	if (h > max) max = h;
      }
    return max;
  }  // maxThrwHeight

  // assumes ample space has been allocated for adding new throws.  we
  // could be nice and allocate enough new space.  nahhhhhh.
  public void addThrow(Thrw thr)
  {
    if(len >= maxlen)
    {
      System.out.println("Throw not added, not enough space allocated");
      return;
    }  

    if(thr.isThr() && len > 0)
      {
	int i = 0;
	while(i < len && ths[i].time < thr.time)
	  i++;
	while(i < len && ths[i].isThr() && 
	      ths[i].height != -1 && ths[i].height != 1) 
	  i++;
	Thrw oldth, newth = ths[i];
	ths[i] = thr;
	while(i < len)
	  {
	    oldth = ths[++i];
	    ths[i] = newth;
	    newth = oldth;
	  }
	len++;
      }
    else
      ths[len++] = thr;

    if(DBG)
    {
      System.out.println("adding throw.....");
      thr.printThrow();
    }
  }  // addThrow
      
  // initializes a 'State' for a new pattern.  pretty ugly code.
  public State initState()
  {
    int idx = 0, j = 0, k = 1;
    int hgt, tm = 0, adj;
    State st = new State(Math.max(maxThrwHeight(false),1));

    st.setSync(sync);
    if(numballs > 0)
      st.lastswi = 1;

    j = 0;
    while(j < numballs)
      {
	hgt = ths[idx].height;

	// shift the pattern back in time to see where we expect
	// balls to be landing
        tm = ths[idx].time - timediff*k;

	if(hgt + tm >= 0)
	  {
	    // if pattern is odd length (async), each time k is incremented,
	    // the hand corresponding to a throw in the pattern changes
	    adj = (k*timediff)%2;
	    if(sync == true)
	      if(ths[idx].isCro())
		st.addLanding((ths[idx].hand + 1)%2, tm+hgt, true);
	      else
		st.addLanding((ths[idx].hand)%2, tm+hgt, true);
	    else
	      st.addLanding((ths[idx].hand + hgt + adj)%2, tm+hgt, true);
	    j++;
	  }
	idx++;
	if(idx >= len)
	  {
	    idx = 0;
	    k++;
	  }
      }
    return st;
  }  // initState()

public void massage()
  {
    //    reduceSequence(false);  
    SetToOutSide();    
  }

public void setMultiplexes()
  {
    boolean ans = false;
    
    for(int i=0; i<len-1 && !ans; i++)
      ans = (ths[i].time == ths[i+1].time);
    multi = ans;
  }

public void setHolds()
  {
    boolean ans = false;
    
    for(int i=0; i<len && !ans; i++)
      ans = (ths[i].height == 2 && !ths[i].isThr());
    holds = ans;
  }

public void SetToOutSide()
  {
    StringBuffer strb;
    int tmpTime, tmpHand, j, k;
    boolean outside = false;

    for(int i=0; i<len; /**/)
      {
	outside = false;
	tmpTime = ths[i].time;
	tmpHand = ths[i].hand;
	j = i;
	while(j < len && ths[j].time == ths[i].time)
	  {
	    if(ths[j].isRev() && ths[j].hand == ths[i].hand)
	      outside = true;
	    j++;
	  }

	if(outside)
	  for(k=0; k < j-i; k++)
	    if(ths[i+k].hand == tmpHand)
	      ths[i+k].setRev(true);
	i = j;
      }
  }


// takes a pattern and reduces it to the shortest repeating string it can.
// eg 501501 -> 501  an alternate reduction would be to find shortest 
// subpatterns, eg 645 -> 64 & 5 (both still 5 ball patterns), this is not 
// what this method does.
public int reduceSequence(boolean ignoreMods)
   {
     int j;
     boolean substr;
     for(int i = 1; i <= (len+1)/2; i++)
       {
         substr = true;
 	j = i;
         while(j < len && substr)
 	{
           if(!Thrw.sameThrow(ths[j], ths[j%i], ignoreMods));
 	    substr = false;
 	  j++;
 	}
         if(substr)
 	  return i;
       }
   
     return len;
   }

// returns -1 if these are not the same pattern.  if they are
// the same pattern returns the numebr of throws that must be
// made from ths1 until they are in sync.
public static int sameSequence(BallSequence seq1, BallSequence seq2, boolean ignoreMods)
  {
    int num1, num2;
    int j;
    boolean equal;
    
    num1 = seq1.reduceSequence(ignoreMods);
    num2 = seq2.reduceSequence(ignoreMods);

    if(num1 != num2)
      return -1;

    for(int i = 0; i < num1; i++)
      {
        equal = true;
	j = 0;
        while(j < num1 && equal)
	  if(!Thrw.sameThrow(seq1.ths[j], seq2.ths[(i+j)%num1], ignoreMods));
	    equal = false;
        if(equal)
	  return (num1 - i)%num1;
      }
      
    return -1;
  }			       
			       
 public boolean validate(Orbits orbits)  {
    Thrw arrow[][];
    int in[][], out[][];
    int patTime;
    int face[][];
    String label[][];
    int newHand, newTime;
    boolean problem = false;

    if(len == 0) return false;
    
    if(sync) patTime = ths[len-1].time + 2;
    else    patTime = ths[len-1].time + 1;

    in = new int[2][patTime];
    out = new int[2][patTime];
    face = new int[patTime][2];
    arrow = new Thrw[len][2];
    label = new String[patTime][2];

    // initialize in and out arrays
    for(int i=0; i < patTime; i++)
      {
	in[0][i] = 0; in[1][i] = 0; 
	out[0][i] = 0; out[1][i] = 0;
	label[i][0] = ""; label[i][1] = "";
      }

    // calculate incoming and outgoing throws for each hand at every time.
    // also add to list of arrows
    for(int i = 0; i < len; i++)
      {
	// construct throw label
	if (label[ths[i].time%patTime][ths[i].hand] != "")
	  label[ths[i].time%patTime][ths[i].hand] += " " +
	    String.valueOf(ths[i].height);
	else
	  label[ths[i].time%patTime][ths[i].hand] += 
	    String.valueOf(ths[i].height);
	if (sync && ths[i].isCro())
	  label[ths[i].time%patTime][ths[i].hand] += "x";

	// find new hand
	newHand = ths[i].hand;
	if((sync && ths[i].isCro()))
	  newHand = (ths[i].hand+1)%2;
	if(!sync && patTime%2 == 0 && ths[i].height%2 == 1)
	  newHand = (ths[i].hand+1)%2;
	if(!sync && patTime%2 == 1)
	  if((ths[i].height+ths[i].time)/patTime == 1)
	    newHand = (ths[i].hand+1)%2;

	// find new time
	newTime = (ths[i].time + ths[i].height)%patTime;

	if(ths[i].height > 0)
	  {
	    out[ths[i].hand][ths[i].time%patTime]++;
	    in[newHand][newTime]++;
	  }
	arrow[i][0] = new Thrw(ths[i].height, ths[i].hand, 
			       ths[i].time%patTime);      
	arrow[i][1] = new Thrw(ths[i].height, newHand, newTime);
      }

    for(int i = 0; i < patTime; i++)
      for(int j = 0; j < 2; j++)
	face[i][j] = 0;

    if(!sync)
      for(int i = 0; i < patTime; i++)
	if((in[0][i] + in[1][i]) == (out[0][i] + out[1][i]))
	  face[i][i%2] = 0; // happy
	else if(in[0][i]+in[1][i] > out[0][i]+out[1][i])
	  {
	    face[i][i%2] = 1; // overfed
	    problem = true;
	  }
	else 
	  { 
	    face[i][i%2] = 2;
	    problem = true; // 
	  }
    else
      for(int i = 0; i < patTime; i++)
	for(int j = 0; j < 2; j++)
	if(in[j][i] == out[j][i])
	  face[i][j] = 0; // happy
	else if(in[j][i] > out[j][i])
	  {
	    face[i][j] = 1; // overfed
	    problem = true;
	  }
	else 
	  { 
	    face[i][j] = 2;
	    problem = true; // underfed
	  }

    if (orbits != null)
      orbits.doOrbits(patTime, len, arrow, face, label, sync);
  
    return !problem;
  }

}
