/*
 * @(#)Body.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Body.java,v 1.9 1997/03/22 04:09:48 mslevine Exp $
 */


/////////////////////////////////////////////////////////////////////////
class Body extends Spriggan
{
  double height, width;
  Image image;

public Body(Juggler j, Image img, double wherex, double wherey, int wherez,
	    double width, double height, Color color)
  {
    init();         // do Spriggan default initialization
    juggler = j;
    image = img;
    this.color = color;
    this.height = height;
    this.width = width;
    pos = new Point3(wherex, wherey, wherez);
  }

public void paint(Graphics g)
  {
    Point center = juggler.scale.mapToPixels(pos);
    int w = juggler.scale.scaleToPixels(.25);
    if (Math.abs(w-lastscale) < 10 ) w = lastscale;
    else lastscale = w;
    g.drawImage(image, center.x-Math.round( (float) (w*width/2) ),
		center.y-Math.round((float)(w*height)), 
		Math.round((float)(w*width)),
		Math.round((float)(w*height)), juggler);
  }

public Point elbowPoint(int hand)
  {
    Point center = juggler.scale.mapToPixels(pos);
    int w = juggler.scale.scaleToPixels(.25);
    if (Math.abs(w-lastscale) <2 ) w = lastscale;
    else lastscale = w;

    if (hand == 0)
      {
	return new Point(center.x-Math.round((float)(2*w*width/5) ),
			 center.y-Math.round((float)(w*height/8)));
      }
    else
      {
	return new Point(center.x+Math.round( (float) (2*w*width/5) ),
			 center.y-Math.round((float)(w*height/8)));
      }
  }

public Point eyesPoint()
  {
    Point center = juggler.scale.mapToPixels(pos);
    int w = juggler.scale.scaleToPixels(.25);
    if (Math.abs(w-lastscale) <2 ) w = lastscale;
    else lastscale = w;

    return new Point(center.x,center.y-Math.round((float)(.77*w*height)));
  }

}	
