/*
 * @(#)BooleanOption.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: BooleanOption.java,v 1.4 1997/03/16 19:36:10 gwar Exp $
 */


class BooleanOption extends Option
{
  boolean dflt;

public BooleanOption(String name, String desc, Object gui_component, 
		     boolean dflt)
  {
    this.name = name;
    this.desc = desc;
    this.gui_component = gui_component;
    this.dflt = dflt;
  }
  
public void reset(JugglerControls evthandler)
  {
    if (gui_component == null) return;
    
    if (gui_component instanceof CheckboxMenuItem)
      ((CheckboxMenuItem)gui_component).setState(dflt);
    else if (gui_component instanceof Checkbox)
      ((Checkbox)gui_component).setState(dflt);
    
    evthandler.handleEvent(new Event(gui_component,Event.ACTION_EVENT,null));
  }

public void getDefault(Juggler juggler)
  {
    String str = juggler.getParameter(name);
    if (str != null)
      dflt = Boolean.valueOf(str).booleanValue();
  }

public String getValue()
  {
    if (gui_component != null) 
      if (gui_component instanceof CheckboxMenuItem)
	return String.valueOf(((CheckboxMenuItem)gui_component).getState());
      else if (gui_component instanceof Checkbox)
	return String.valueOf(((Checkbox)gui_component).getState());
    return String.valueOf(dflt);
  }

public String getType()
  {
    return "boolean  ";
  }

}
