/*
 * @(#)CompoundPath.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.util.Vector;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: CompoundPath.java,v 1.6 1997/03/16 19:36:10 gwar Exp $
 */


/////////////////////////////////////////////////////////////////////////
// a bunch of paths. currently both balls and hands only talk to the
// taskmaster at catch time, so they get two paths. (for a ball
// carry+throw, for a hand carry+return)

class CompoundPath extends Path
{
  Vector paths;
  
  public CompoundPath(double starttime, double duration)
    {
      this.starttime = starttime;
      endtime = starttime+duration;
      paths = new Vector(2,2);
    }
  
  public void addPath(SimplePath s)
    {
      paths.addElement(s);
    }

  public Point3 interpolate(double now)
    {
      int i=0;
      while (i<paths.size() && now >
      ((SimplePath)paths.elementAt(i)).endtime)
        i++;
      if (i >= paths.size())
        {
          System.out.println("interpolate is being asked to find a point off the end of the current path");
          return new Point3(0.,0.,0.);
        }
      else return ((SimplePath)paths.elementAt(i)).interpolate(now);
    }
  
  public Point3 end()
    {
      return ((SimplePath)paths.elementAt(paths.size()-1)).end();
    }
}
