/*
 * @(#)DummyOption.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: DummyOption.java,v 1.4 1997/03/16 19:36:11 gwar Exp $
 */


class DummyOption extends Option
{
  String type;
  String dflt;

public DummyOption(String name, String desc, String type, String dflt)
  {
    this.name = name;
    this.desc = desc;
    this.type = type;
    this.dflt = dflt;
    gui_component = null;
  }

public void reset(JugglerControls evthandler)
  {
  }
  
public void getDefault(Juggler juggler)
  {
    char emptystr[] = {'"', '"'};
    String str = juggler.getParameter(name);
    if (str != null) dflt = str;
    if (dflt == null || dflt.compareTo("") == 0 ) 
      dflt = new String(emptystr);
  }

public String getValue()
  {
    return dflt;
  }

public String getType()
  {
    return type;
  }
}
