/*
 * @(#)EVector.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: EVector.java,v 1.3 1997/03/16 19:36:11 gwar Exp $
 */

import java.lang.*;

// Vectors in the normal mathematical sense. Originally written to
// represent eigenvectors in spectral embedding computations.
// In this file norm always means L2.

public class EVector
{
  double vals[];
  int n;

public EVector(int n)
  {
    this.n = n;
    vals = new double[n];
  }
  
  // set to constant vector with norm = 1
public void cnst()
  {
    double val = 1./Math.sqrt(n);
    for(int i=0; i<n; i++) vals[i] = val;
  }

  // set to random vector
public void rand()
  {
    for(int i=0; i<n; i++) vals[i] = Math.random();
  }

  // return (standard) inner product with e
public double innerprod(EVector e)
  {
    double ans = 0;
    for(int i=0; i<n; i++) ans += vals[i]*e.vals[i];
    return ans;
  }

  // renormalize (scale such that norm = 1)
public void renorm()
  {
    double fact = 1./Math.sqrt(innerprod(this));
    for(int i=0; i<n; i++) vals[i] *= fact;
  }

  // make orthoganal to perp by subtracting off component in that direction
  // assumes perp is a unit vector
public void orthogonalize(EVector perp)
  {
    double val = innerprod(perp);
    for(int i=0; i<n; i++) vals[i] -= val*perp.vals[i];
  }
  
  // return the norm squared of the difference betwen this and e
public double normSqrOfDifference(EVector e)
  {
    double ans = 0, t;
    for (int i=0; i<n; i++)
      {
	t = vals[i]-e.vals[i];
	ans += t*t;
      }
    return ans;
  }

public void print()
  {
    for(int i=0; i<n; i++) System.out.print(vals[i]+" ");
    System.out.println("");
  }
  
}
