/*
 * @(#)Edge.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Edge.java,v 1.12 1997/03/22 05:12:56 gwar Exp $
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.lang.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

class Edge
{
  static String EDGETOK = new String("->");

  Node start;
  Node end;

  Thrw thrw;

  String th;
  String label;

  Color color;

public static String name(Node a, Node b)
  {
    return new String(a.label + EDGETOK + b.label);
  }

public Edge(Node a, Node b, Vector ths)
  {
    this.start = a;
    this.end = b;
    //this.thrw = thrw.copy();

    this.color = Color.black;
    this.label = name(a, b);
    this.th = getName(ths);
  }

public String getName(Vector ths)
  {
    StringBuffer str1, str2;
    StringBuffer fi = new StringBuffer();

    str1 = Thrw.readNames(ths, 0); // hand 2
    str2 = Thrw.readNames(ths, 1); // hand 1
    if(start.st.isSync())
      {
	if(str1.length() == 0)
	  str1.append('0');
	if(str2.length() == 0)
	  str2.append('0');
	fi.append("(" + str1 + "," + str2 + ")");
	return fi.toString();
      }
    if(str1.length() > 0)
      return str1.toString();
    if(str2.length() > 0)
      return str2.toString();
    return new String("0");
  }

public void setColor(Color col)
  {
    color = col;
  }

public void printEdge()
  {
    System.out.println(label);
  }

public boolean equals(Edge ed)
  {
    return ed.start.equals(ed.end);
  }

public String toKey()
  {
    return label;
  }

public void paint(Graphics g, Dimension d, Point ori, FontMetrics fm)
  {
    g.setColor(Color.black);
    int dx1, dy1, dx2 = end.box.x, dy2 = end.box.y;
    int nodedx, nodedy, xmod = 1, ymod = 1;
    double slope;

    nodedx = end.coord.x - start.coord.x;
    nodedy = end.coord.y - start.coord.y;
    if(nodedx == 0 && nodedy == 0)
      {
	int w = fm.stringWidth(th);
	g.drawArc(ori.x + start.coord.x - 7, 
		  ori.y + start.coord.y - start.box.y- 20,
		  14, 20, 250, -320);
	g.drawString(th, ori.x + start.coord.x -w/2,
		     ori.y + start.coord.y - start.box.y - 23);
	return;
      }

    if(nodedx == 0) nodedx = 1;
    if(nodedy == 0) nodedy = 1;

    if(nodedx < 0) xmod = -1;
    if(nodedy < 0) ymod = -1;

    if(nodedy == 0)
      {
	slope = 0;
	g.drawLine(ori.x + start.coord.x + xmod * start.box.x, 
		   ori.y + start.coord.y,
		   ori.x + end.coord.x - xmod * end.box.x, 
		   ori.y + end.coord.y);
	dx2 = end.box.x;
	dy2 = 0;
      }
    else if(nodedx == 0)
      {
	slope = 100000;  // big number
	g.drawLine(ori.x + start.coord.x,
		   ori.y + start.coord.y + ymod * start.box.y, 
		   ori.x + end.coord.x,
		   ori.y + end.coord.y - ymod * end.box.y);
	dx2 = 0;
	dy2 = end.box.y;
      }
    else
      {
	start.box.x = Math.max(start.box.x, 1);
	end.box.x = Math.max(end.box.x, 1);
	if((slope = Math.abs(nodedy*1.0 / nodedx)) < start.box.y*1.0 / start.box.x)
	  {
	    dx1 = start.box.x;
	    dy1 = (int) (slope * start.box.x);
	  }
	else
	  {
	    dx1 = (int) (start.box.y*1.0 / slope);
	    dy1 = start.box.y;
	  }
	if(slope < end.box.y*1.0 / end.box.x)
	  {
	    dx2 = end.box.x;
	    dy2 = (int) (slope * end.box.x);
	  }
	else
	  {
	    dx2 = (int) (end.box.y*1.0 / slope);
	    dy2 = end.box.y;
	  }

	g.drawLine(ori.x + start.coord.x + xmod * dx1,
	           ori.y + start.coord.y + ymod * dy1, 
		   ori.x + end.coord.x - xmod * dx2,
		   ori.y + end.coord.y - ymod * dy2);
      }

    // draw arrowhead
    double ang1 = Math.atan(slope) + Math.PI / 6;
    double ang2 = Math.atan(slope) - Math.PI / 6;

    g.drawLine(ori.x + end.coord.x - xmod * dx2, 
	       ori.y + end.coord.y - ymod * dy2, 
       ori.x + end.coord.x - xmod * (dx2 + (int)(12*Math.cos(ang1))),
       ori.y + end.coord.y - ymod * (dy2 + (int)(12*Math.sin(ang1))));
    g.drawLine(ori.x + end.coord.x - xmod * dx2, 
	       ori.y + end.coord.y - ymod * dy2, 
       ori.x + end.coord.x - xmod * (dx2 + (int)(12*Math.cos(ang2))),
       ori.y + end.coord.y - ymod * (dy2 + (int)(12*Math.sin(ang2))));

    // draw label - should be made a little more efficient
    // these are coords of center of edge
    dx1 = ori.x + start.coord.x + nodedx/3;
    dy1 = ori.y + start.coord.y + nodedy/3;

    // String th = new String("asdfasdf");
    // width, height of label
    int w = fm.stringWidth(th);
    int h = fm.getHeight();
    int cs = Math.abs((int)(nodedx / (nodedx*nodedx + nodedy*nodedy)));
    int si = Math.abs((int)(nodedy / (nodedx*nodedx + nodedy*nodedy)));
    //    int h = 5;

    if(nodedx > 0)
      if(nodedy > 0)
	g.drawString(th, (int) (dx1 + si*h + h/2), 
		     (int) (dy1 - cs*h));
      else
	g.drawString(th, (int) (dx1 + si*h + h/2), 
		     (int) (dy1 + cs*h + h));
    else
      if(nodedy > 0)
	g.drawString(th, (int) (dx1 - si*h - w - h/2), 
		     (int) (dy1 - cs*h));
      else
	g.drawString(th, (int) (dx1 - si*h - w - h/2), 
		     (int) (dy1 + cs*h + h));
  }

public void clicked(int x, int y)
  {
  }

}
