/*
 * @(#)Finger.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Finger.java,v 1.11 1997/03/16 19:36:12 gwar Exp $
 */

////////////////////////////////////////////////////////////////
class Finger extends Spriggan
{
  Hand hand;
  Image image, image2;
  
public Finger(Juggler j, Color color, Hand hand)
  {
    init();   // do Spriggan default initialization
    this.color = color;
    juggler = j;
    this.hand = hand;
    if (hand.hand == 0)
      {
	image = juggler.getImage("pics/rfingers.gif");
	image2 = juggler.getImage("pics/rpointerfingers.gif");
      }
    else
      {
	image = juggler.getImage("pics/lfingers.gif");
	image2 = juggler.getImage("pics/lpointerfingers.gif");
      }

    pos = new Point3(0,0,1000000000);
  }

public void paint(Graphics g)
  {
    Point center = juggler.scale.mapToPixels(hand.pos);
    int w = juggler.scale.scaleToPixels(.2);
    if (Math.abs(w-lastscale) <2 ) w = lastscale;
    else lastscale = w;
    if (hand.zero)
      {
	int w2 = (int)(w*.65);
	g.drawImage(image2, center.x-w2/2, center.y-w, w2, w, juggler);
      }
    else
      g.drawImage(image, center.x-w/2, center.y-w, w, w, juggler);
  }

}	
