/*
 * @(#)GeometryOption.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: GeometryOption.java,v 1.7 1997/03/16 19:36:13 gwar Exp $
 */


class GeometryOption extends Option
{
  int x, y, width, height;

public GeometryOption(String name, String desc, Object gui_component, 
		      int x, int y, int width, int height)
  {
    this.name = name;
    this.desc = desc;
    this.gui_component = gui_component;
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
  }

public void reset(JugglerControls evthandler)
  {
    if (gui_component != null)
      if (gui_component instanceof Frame)
	{
	  ((Frame)gui_component).reshape(x, y, width, height);
	  // I can't tell if the following is actually required or
	  // merely works around an AWT bug
	  ((Frame)gui_component).layout();
	}
  }

public void getDefault(Juggler juggler)
  {
    String str = juggler.getParameter(name);
    if (str == null) return;
    str = str.trim();
    int xp = str.indexOf('x');
    int pp1 = str.indexOf('+');
    if (pp1 < 0) pp1 = str.indexOf('-');
    int pp2=-1;
    if (pp1 >= 0)
      {
	pp2 = str.indexOf('+', pp1+1);
	if (pp2 < 0) pp2 = str.indexOf('-', pp1+1);
      }
    if (xp >= 0)
      {
	try {
	  width = Integer.valueOf(str.substring(0, xp)).intValue();
	} catch (NumberFormatException e) { }
	if (pp1 >= 0)
	  try {
	    height = Integer.valueOf(str.substring(xp+1, pp1)).intValue();
	  } catch (NumberFormatException e) { }
	else
	  try {
	    height=Integer.valueOf(str.substring(xp+1,str.length())).intValue();
	  } catch (NumberFormatException e) { }
      }
    else xp = 0;
    if (pp1 >= 0 && pp2 >= 0)
      {
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	try {
	  x = Integer.valueOf(str.substring(pp1+1, pp2)).intValue();
	} catch (NumberFormatException e) { }
	if (str.charAt(pp1) == '-') x = d.width-width-x;
	try {
	  y = Integer.valueOf(str.substring(pp2+1, str.length())).intValue();
	} catch (NumberFormatException e) { }
	if (str.charAt(pp2) == '-') y = d.height-height-y;
      }
  }

public String getValue()
  {
    if (gui_component != null && gui_component instanceof Component)
      {
	Rectangle r = ((Component)gui_component).bounds();
	return "" + r.width +"x"+r.height+"+"+r.x+"+"+r.y;
      }
    return "";
  }

public String getType()
  {
    return "WxH+X+Y ";
  }

}
