/*
 * @(#)Hand.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;
import java.net.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Hand.java,v 1.23 1997/03/22 03:20:57 mslevine Exp $
 */

////////////////////////////////////////////////////////////////
class Hand extends Spriggan
{
  int hand;
  Image image, image2;
  Body body;
  String label;
  boolean zero;

public Hand(Juggler j, Color color, int hand, Body body)
  {
    init();   // do Spriggan default initialization
    this.body = body;
    path.addPath(new Hold(new Point3(0., 0., -1000000000.), 0, 0));
    pos.z = -100000000.;
    juggler = j;
    if (hand == 0)
      {
	image = juggler.getImage("pics/rhand.gif");
	image2 = juggler.getImage("pics/rpointerhand.gif");
      }
    else
      {
	image = juggler.getImage("pics/lhand.gif");
	image2 = juggler.getImage("pics/lpointerhand.gif");
      }
    this.hand = hand;
    this.color = color;
  }

public boolean move(double now)
  {
    if (path.isDone(now))
      juggler.taskmaster.updateHand(this);
    pos = path.interpolate(now);
    return true;
  }
  
public void paint(Graphics g)
  {
    g.setColor(color);
    Point center = juggler.scale.mapToPixels(pos);
    int w = juggler.scale.scaleToPixels(.2);
    if (Math.abs(w-lastscale) <2 ) w = lastscale;
    else lastscale = w;

    if (juggler.controls.showjuggler.getState())
      {
	if (zero)
	  {
	    int w2 = (int)(w*.65);
	    g.drawImage(image2, center.x-w2/2, center.y-w, w2, w, 
			juggler);
	  }
	else
	  g.drawImage(image, center.x-w/2, center.y-w, w, w, juggler);

	// draw arms
	Point elbow = body.elbowPoint(hand);
	Point org = juggler.scale.mapToPixels(new Point3(0.,0.,0.));
	elbow.x += (center.x-org.x)/3;
	g.drawLine(center.x, center.y-w, elbow.x, elbow.y);
      }
    
    if (juggler.controls.labelhands.getState() && label != null)
      {
	if (juggler.handfont==null || 
	    Math.abs(3*w/4 - juggler.handfont.getSize()) > 2) 
	  juggler.handfont = new Font("Helvetica", Font.PLAIN, 3*w/4);
	g.setFont(juggler.handfont);
	FontMetrics fm = g.getFontMetrics();
	g.drawString(label, center.x-fm.stringWidth(label)/2, center.y+w);
      }
  }

}	
