/*
 * @(#)HandPattern.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.Vector;

class HandPattern
{
  int lasttime;
  int length=50;
  Point3 ctch[][];
  int ctchcnt[][];
  Point3 defctch[];
  Point3 thrw[];
  Point3 rthrw[];
  double handdip, handswing, handspread, baseheight=0.;
  double handoffset;

public HandPattern()
  {
    ctch = new Point3[2][length];
    ctchcnt = new int[2][length];
    thrw = new Point3[2];
    rthrw = new Point3[2];
    defctch = new Point3[2];
    handdip = .1; 
    handspread = .4;
    handswing = .2;
    handoffset = .02;
    setPositions();
  }
  
public Point3 ctchPosAtTime(int hand, int now, int time, boolean ball)
  {
    int i;
    if (now < 0) now = 0;  //kludge for pattern starting time at -1
    if (time < 0) time = 0;  //kludge for pattern starting time at -1
    int n = now%length;
    int lt = lasttime%length;
    if (lt > n)
      {
	for(i=lt; i<length; i++) 
	  {
	    ctch[0][i] = ctch[1][i] = null;
	    ctchcnt[0][i] = ctchcnt[1][i] = 0;
	  }
	lt = 0;
      }
    for(i=lt; i<n; i++) 
      {
	ctch[0][i] = ctch[1][i] = null;
	ctchcnt[0][i] = ctchcnt[1][i] = 0;
      }
    lasttime = now;
    if (ctch[hand][time%length] == null)
      ctch[hand][time%length] = defctch[hand];
    Point3 ans = ctch[hand][time%length].copy();
    if (ball) 
      {
	ans.z = -++ctchcnt[hand][time%length];
	ans.y -= handoffset*ans.z;    
      }
    else ans.z = -1000000000.;
    return ans;
  }

public Point3 thrwPosAtTime(int hand, int now, int time, double prevz,
	boolean reverse)
  { 
    Point3 ans;
    if (reverse) ans = rthrw[hand].copy();
    else ans = thrw[hand].copy();
    ans.z = prevz;
    if (prevz > -1000000000.)
      ans.y -= handoffset*ans.z;
    return ans;
  }

public double height(double z)
  {
    if (z>-1000000000.)
      return baseheight-handoffset*z;
    return baseheight;
  }

public double dip(double z)
  {
    if (z>-1000000000.)
      return baseheight-handdip-handoffset*z;
    return baseheight-handdip;
  }

public void setHandDip(double val)
  {
    handdip = val;
    setPositions();
  }

public void setHandSwing(double val)
  {
    handswing = val;
    setPositions();
  }

public void setHandSpread(double val)
  {
    handspread = val;
    setPositions();
  }

public void setLength(int len)
  {
    if (len <= length) return;  // never shrinks!
    Point3 nctch[][] = new Point3[2][len];
    int nctchcnt[][] = new int[2][len];    
    int lt = lasttime % length;
    int nt = lasttime % len;
    for(int i=0; i<length; i++)
      {
	nctch[0][(nt+i)%len] = ctch[0][(lt+i)%length];
	nctch[1][(nt+i)%len] = ctch[1][(lt+i)%length];
	nctchcnt[0][(nt+i)%len] = ctchcnt[0][(lt+i)%length];
	nctchcnt[1][(nt+i)%len] = ctchcnt[1][(lt+i)%length];
      }
    length = len;
    ctch = nctch;
    ctchcnt = nctchcnt;
  }

private void setPositions()
  {
    defctch[0] = new Point3(-handspread, baseheight, 0);
    thrw[0] = new Point3(-handspread+handswing, baseheight, 0);
    rthrw[0] = new Point3(-handspread-handswing, baseheight, 0);
    defctch[1] = new Point3(handspread, baseheight, 0);
    thrw[1] = new Point3(handspread-handswing, baseheight, 0);
    rthrw[1] = new Point3(handspread+handswing, baseheight, 0);
  }

}
