/*
 * @(#)History.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;
import java.util.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: History.java,v 1.8 1997/03/16 19:36:14 gwar Exp $
 */

class History extends Menu
{
  Juggler juggler;
  Vector items;
  Hashtable uniqitems;
  UniqueHistoryItem first, current;
  String partialentry;

public History(String name, boolean tearoff, Juggler j)
  {
    super(name, tearoff);
    items = new Vector();
    uniqitems = new Hashtable();
    juggler = j;
    first = current = new UniqueHistoryItem(null);
    first.next = first.prev = first;
    first.seq = null;
    partialentry=null;
  }

public void notifyNewSequence(Sequence seq)
  {
    current = (UniqueHistoryItem)uniqitems.get(seq.name);
    if (current == null)   // new pattern
      {
	current = new UniqueHistoryItem(seq.name);
	current.seq = seq;
	uniqitems.put(seq.name, current);
      }
    else  //  we've seen this pattern before
      {
	current.prev.next = current.next;
	current.next.prev = current.prev;
	remove(current);
      }
    add(current);
    current.prev = first.prev;
    current.next = first;
    first.prev.next = current;
    first.prev = current;
    items.addElement(seq);
  }

  // current would be a misnomer
  // returns the last non-random pattern we chose to juggle that parsed ok
public Sequence mostRecent()
  {
    if (current.seq != null)
      return current.seq;
    else
      return current.prev.seq;
  }

public String prev()
  {
    current = current.prev;
    if (current.seq != null)
      return current.seq.name;
    else
      return partialentry;
  }

public String next()
  {
    current = current.next;
    if (current.seq != null)
      return current.seq.name;
    else
      return partialentry;
  }

public void savePartialEntry(String p)
  {
    if (partialentry != null)
      if (current.seq == null)
	{
	  if (partialentry.compareTo(p) != 0)
	    partialentry = p;
	}
      else if (current.seq.name.compareTo(p) != 0)
	{
	  partialentry = p;
	  first.prev.next = first.next;
	  first.next.prev = first.prev;
	  first.next = current.next;
	  first.prev = current;
	  current.next.prev = first;
	  current.next = first;
	  current = first;
	}
  }

public boolean handleEvent(Event ev)
  {
    if (ev.id == Event.ACTION_EVENT && ev.target instanceof UniqueHistoryItem)
      {
	current = (UniqueHistoryItem)ev.target;
	juggler.setSequenceFromHistory(((UniqueHistoryItem)ev.target).seq);
	return true;
      }
    return false;
  }

public void saveAsHotlist()
  {
    String homedir = System.getProperty("user.home", "");
    File hl = new File(homedir, ".juggler.hotlist");
    File oldhl = null;
    if (hl.exists())
      {
	oldhl = new File(homedir, ".juggler.hotlist.old");
	if (!hl.renameTo(oldhl))
	  {
	    // error
	    juggler.message.showMessage("An error occured while trying to save options.\nOld .juggler.hotlist file should be intact.");
	    return;
	  }
      }
    PrintStream out;
    try
      {
	out = new PrintStream(new FileOutputStream(hl));
	UniqueHistoryItem tmp = first.next;
	while (tmp != first)
	  {
	    out.println(tmp.seq.name);
	    tmp = tmp.next;
	  }
      }
    catch (IOException e) 
      {
	//error 
	hl.delete();
	if (oldhl != null && !oldhl.renameTo(hl))
	  {
	    // error -- lost old hl
	    juggler.message.showMessage("An error occured while trying to save hotlist. Unfortunately another\n occured trying to restore your old .juggler.hotlist. .juggler.hotlist may be lost.");
	    return;
	  }
	else
	  {
	    // restored old hl
	    juggler.message.showMessage("An error occured while trying to save hotlist.\nOld .juggler.hotlist file was restored.");
	    return;
	  }
      }
    if (out != null) out.close();
  }

public void initAsHotlist()
  {
    String homedir = System.getProperty("user.home", "");
    File hl = new File(homedir, ".juggler.hotlist");
    int i;
    Sequence seq;
    boolean multerrs = false;
    int error = 0;
    String errmsg = "";
    if (hl.exists() && hl.canRead())
      {
	try 
	  {
	    FileInputStream hlis = new FileInputStream(hl);
	    StreamTokenizer hlst = new StreamTokenizer(hlis);
	    hlst.slashSlashComments(true);
	    hlst.slashStarComments(true);
	    hlst.quoteChar('"');
	    hlst.ordinaryChars('0', '9');
	    hlst.ordinaryChar('[');
	    hlst.ordinaryChar(']');
	    hlst.ordinaryChar('(');
	    hlst.ordinaryChar(')');
	    hlst.ordinaryChar(',');
	    hlst.ordinaryChar('-');
	    hlst.ordinaryChar('+');
	    hlst.wordChars('0', '9');
	    hlst.wordChars('[', '[');
	    hlst.wordChars(']', ']');
	    hlst.wordChars('(', '(');
	    hlst.wordChars(')', ')');
	    hlst.wordChars(',', ',');
	    hlst.wordChars('-', '-');
	    hlst.wordChars('+', '+');
	    
	  rcinput: while (true)
	    {
	      try {i=hlst.nextToken();}
	      catch (IOException ioe) { break; }
	      switch (i)
		{
		case StreamTokenizer.TT_WORD:
		case '"':
		  seq = juggler.pattern.parseString(hlst.sval);
		  if (seq == null) 
		    if (error > 0) 
		      multerrs = true;
		    else
		      {
			error = hlst.lineno();
			errmsg = juggler.pattern.parser.errormessages[juggler.pattern.parser.errcode];
		      }
		  else
		    notifyNewSequence(seq);
		  break;
		case StreamTokenizer.TT_EOF:
		  break rcinput;
		}
	    }
	  }
	catch (FileNotFoundException e) {}
      }

    if (multerrs)
      juggler.message.showMessage("Multiple errors occurred when reading hotlist. The first is line " + error + ":\n" + errmsg);
    else if (error > 0)
      juggler.message.showMessage("An error occurred when reading hotlist line " + error + ":\n" + errmsg);
    

  }
}

