/*
 * @(#)IntOption.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: IntOption.java,v 1.5 1997/03/16 19:36:14 gwar Exp $
 */

class IntOption extends Option
{
  int dflt, lower, upper;

public IntOption(String name, String desc, Object gui_component, int dflt, 
	      int lower, int upper)
  {
    this.name = name;
    this.desc = desc;
    this.gui_component = gui_component;
    this.dflt = dflt;
    this.lower = lower;
    this.upper = upper;
  }
  
public void reset(JugglerControls evthandler)
  {
    if (gui_component != null && gui_component instanceof Scrollbar)
      {
	((Scrollbar)gui_component).setValue(dflt); 
	evthandler.handleEvent(new Event(gui_component,
					 Event.ACTION_EVENT,null));
      }
  }

public void getDefault(Juggler juggler)
  {
    String str = juggler.getParameter(name);
    if (str != null)
      {
	try {
	  dflt = Integer.valueOf(str).intValue();
	} catch (NumberFormatException e) { }
	if (dflt < lower) dflt = lower;
	if (dflt > upper) dflt = upper;	  
      }
  }

public String getValue()
  {
    if (gui_component != null) 
      if (gui_component instanceof Scrollbar)
	return String.valueOf(((Scrollbar)gui_component).getValue());
    return "";
  }

public String getType()
  {
    return "int      ";
  }

}
