/*
 * @(#)JugglerControls.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: JugglerControls.java,v 1.63 1997/04/14 00:03:50 gwar Exp $
 */

class JugglerControls extends MenuBar
{
  Juggler juggler;

  Vector options;

  /* file */

  Menu mode;
  MenuItem normal;
  MenuItem random;
  MenuItem sgdriven;
  MenuItem quit;
  // Future thoughts: scripts
  //    load script
  //    restart script
  //    edit script?
  //    record script?

  /* view (now named options (oh well))*/
  Menu view;
  CheckboxMenuItem showjuggler;      
  CheckboxMenuItem showtrails;       
  CheckboxMenuItem numbersforballs;  
  CheckboxMenuItem fakeheights;      
  CheckboxMenuItem labelhands;       
  CheckboxMenuItem trippycolors;     
  CheckboxMenuItem aliceballs;     
  CheckboxMenuItem st_vertical;      
  CheckboxMenuItem st_shownumbers;   

  CheckboxMenuItem showstategraph;   
  CheckboxMenuItem showspacetime;    
  CheckboxMenuItem showorbits;       

  CheckboxMenuItem manualzoom;       
  MenuItem bzoomout;
  MenuItem lzoomout; 
  MenuItem lzoomin; 
  MenuItem bzoomin;  

  CheckboxMenuItem savelayout;
  CheckboxMenuItem saveoptions;
  MenuItem resetlayout;
  MenuItem reset;

  /* settings window */
  CheckboxMenuItem showsettings;
  SlaveFrame settings;
  Panel labels, sliders, buttons;
  Scrollbar speed;                   
  Scrollbar ballsize;                
  double ballscale=1.;
  Scrollbar handdip;                 
  Scrollbar handspread;              
  Scrollbar handswing;               
  Scrollbar zoomdelay;               
  Scrollbar gravity;                 
  Scrollbar randomness;              
  Scrollbar st_scale;                
  Scrollbar st_width;                
  Scrollbar st_textoffset;           

  /* hotlist */
  History hotlist;
  MenuItem addpattern;

  /* history */
  History history;

  Menu samples;
  Menu s_assorted;
  Menu s_3trick;
  Menu s_4trick;
  Menu s_5trick;
  Menu s_sync;
  Menu s_multi;
  Menu s_bounce;
  Menu s_absurd;

  /* help */
  Menu help;
  MenuItem about;
  MenuItem whomagnus;
  MenuItem patternentry;
  MenuItem spacetime;
  MenuItem stategraph;
  MenuItem orbits;
  MenuItem paraminfo;
  MenuItem copying;
  MenuItem warranty;
  SlaveFrame helpframe;
  TextArea helptextarea;
  Button helpdone;

public JugglerControls(Juggler juggler)
  {
    this.juggler = juggler;
    options = new Vector();
    
    add(mode = new Menu("Mode"));
    mode.add(normal = new MenuItem("Normal"));
    mode.add(random = new MenuItem("Random"));
    // mode.add(sgdriven = new MenuItem("State Graph Driven"));
    mode.addSeparator();
    mode.add(quit = new MenuItem("Quit"));
    // sgdriven.disable();  // not implemented 
    
    add(view = new Menu("Options", true));
    view.add(showjuggler = new CheckboxMenuItem("Show juggler"));
    options.addElement(new BooleanOption("showjuggler", "Show juggler", 
					 showjuggler, true));
    view.add(showtrails = new CheckboxMenuItem("Show trails"));      
    options.addElement(new BooleanOption("showtrails", "Show trails", 
					 showtrails,  false));
    view.add(numbersforballs = new CheckboxMenuItem("Show numbers for balls"));
    options.addElement(new BooleanOption("numbersforballs", 
					 "Show numbers for balls", 
					 numbersforballs, false));     
    view.add(fakeheights = new CheckboxMenuItem("Use fake (linear) heights"));
    options.addElement(new BooleanOption("fakeheights", 
					 "Use fake (linear) heights", 
					 fakeheights, false));     
    view.add(labelhands = new CheckboxMenuItem("Label hands w/ throws"));      
    options.addElement(new BooleanOption("labelhands", 
					 "Label hands w/ throws", 
					 labelhands, false));     
    view.add(trippycolors = new CheckboxMenuItem("Trippy colors"));    
    options.addElement(new BooleanOption("trippycolors", "Trippy colors", 
					 trippycolors, false));
    view.add(aliceballs = new CheckboxMenuItem("Alice Balls"));    
    options.addElement(new BooleanOption("aliceballs", "Alice balls", 
					 aliceballs, false));
    view.add(st_vertical = new CheckboxMenuItem("S-T: vertical display"));     
    options.addElement(new BooleanOption("st_vertical", 
					 "S-T: vertical display", 
					 st_vertical, false));     
    view.add(st_shownumbers = new CheckboxMenuItem("S-T: show numbers"));   
    options.addElement(new BooleanOption("st_shownumbers", 
					 "S-T: show numbers", 
					 st_shownumbers, true));     
    view.addSeparator();
    view.add(showsettings = new CheckboxMenuItem("Show Settings Window"));
    options.addElement(new BooleanOption("showsettings","Show Settings Window",
					 showsettings, false));     
    view.add(showstategraph = new CheckboxMenuItem("Show State Graph"));  
    options.addElement(new BooleanOption("showstategraph", "Show State Graph", 
					 showstategraph, false));     
    view.add(showspacetime = new CheckboxMenuItem("Show Space-Time Diagram"));
    options.addElement(new BooleanOption("showspacetime", 
					 "Show Space-Time Diagram", 
					 showspacetime, false));     
    view.add(showorbits = new CheckboxMenuItem("Show Orbits"));      
    options.addElement(new BooleanOption("showorbits", "Show Orbit", showorbits,
					 false));     
    view.addSeparator();
    view.add(manualzoom = new CheckboxMenuItem("Manual Zoom"));     
    options.addElement(new BooleanOption("manualzoom", "Manual Zoom", 
					 manualzoom, false));  
    view.add(bzoomout = new MenuItem("Magnify 0.66X"));
    view.add(lzoomout = new MenuItem("Magnify 0.95X"));
    view.add(lzoomin = new MenuItem("Magnify 1.05X"));
    view.add(bzoomin = new MenuItem("Magnify 1.50X"));
    view.addSeparator();
    view.add(savelayout = new CheckboxMenuItem("Save Window Layout"));
    options.addElement(new BooleanOption("savelayout", "Save Window Layout", 
					 savelayout,  false));  
    view.add(saveoptions = new CheckboxMenuItem("Save Options on Exit"));
    options.addElement(new BooleanOption("saveoptions", 
					 "Save Options on Exit", 
					 saveoptions,  false));  
    if (juggler.applet != null) 
      {
	savelayout.disable();
	saveoptions.disable();
      }
    view.addSeparator();
    view.add(resetlayout = new MenuItem("Reset Window Layout"));
    view.add(reset = new MenuItem("Reset Options"));

    settings = new SlaveFrame(juggler);
    settings.setTitle("Juggler Settings");
    settings.setLayout(new BorderLayout());
    labels = new Panel();
    labels.setLayout(new GridLayout(11,1));
    sliders = new Panel();
    sliders.setLayout(new GridLayout(11,1));

    labels.add("1", new Label("Speed"));
    sliders.add("1", speed = new Scrollbar(Scrollbar.HORIZONTAL, 50, 6, 1, 
					   100));
    options.addElement(new IntOption("speed", "Speed", speed, 50, 1, 100));

    labels.add("2", new Label("Ball size"));
    sliders.add("2", ballsize = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, -7,
					      15));
    options.addElement(new IntOption("ballsize", "Ball size", ballsize, 
				     0, -7, 15));

    labels.add("3", new Label("Hand dip"));
    sliders.add("3", handdip = new Scrollbar(Scrollbar.HORIZONTAL, 10, 5, 1, 
					     80));
    options.addElement(new IntOption("handdip", "Hand dip", handdip, 
				     10, 1, 80));

    labels.add("4", new Label("Hand spread"));
    sliders.add("4", handspread = new Scrollbar(Scrollbar.HORIZONTAL, 5, 3, 
					      -5, 80));
    options.addElement(new IntOption("handspread", "Hand spread", handspread, 
				     5, -5, 80));

    labels.add("5", new Label("Hand swing"));
    sliders.add("5", handswing = new Scrollbar(Scrollbar.HORIZONTAL, 2, 3,
					       0, 20));
    options.addElement(new IntOption("handswing", "Hand swing", handswing, 2, 
				  0, 20));

    labels.add("6", new Label("Zoom delay"));
    sliders.add("6", zoomdelay = new Scrollbar(Scrollbar.HORIZONTAL, 3, 2, 0, 
					     10));
    options.addElement(new IntOption("zoomdelay", "Zoom delay", zoomdelay, 
				     3, 0, 10));

    labels.add("7", new Label("Gravity"));
    sliders.add("7", gravity = new Scrollbar(Scrollbar.HORIZONTAL, 25, 5, 1, 
					     50));
    options.addElement(new IntOption("gravity", "Gravity", gravity, 25, 1, 50));

    labels.add("8", new Label("Randomness"));
    sliders.add("8", randomness = new Scrollbar(Scrollbar.HORIZONTAL, 10, 3,
						1, 20));
    options.addElement(new IntOption("randomness", "Randomness", randomness, 
				     10, 1, 20));

    labels.add("9", new Label("ST: scale"));
    sliders.add("9", st_scale = new Scrollbar(Scrollbar.HORIZONTAL, 13, 5,
						  1, 100));
    options.addElement(new IntOption("st_scale", "ST: scale", st_scale, 
				     13, 1, 100));
    
    labels.add("10", new Label("ST: width"));
    sliders.add("10", st_width = new Scrollbar(Scrollbar.HORIZONTAL, 40, 5,
						  1, 100));
    options.addElement(new IntOption("st_width", "ST: width", st_width, 
				     40, 1, 100));

    labels.add("11", new Label("ST: text offset"));
    sliders.add("11", st_textoffset = new Scrollbar(Scrollbar.HORIZONTAL, 40, 
						    5, 1, 100));
    options.addElement(new IntOption("st_textoffset", "ST: text offset", 
				     st_textoffset, 40, 1, 100));

    settings.add("West", labels);
    settings.add("Center", sliders);
    settings.pack();

    /* hotlist */
    if (juggler.applet == null)
      {
	add(hotlist = new History("Hotlist", true, juggler));
	hotlist.add(addpattern = new MenuItem("Add pattern"));
	hotlist.addSeparator();
      }

    /* history */
    add(history = new History("History", true, juggler));

    /* samples */
    add(samples = new Menu("Samples", true));
    samples.add(s_assorted = new Menu("Assorted siteswaps", true));
    s_assorted.add("534r");
    s_assorted.add("5 6r 1");
    s_assorted.add("10r 1 6r 1 2");
    s_assorted.add("(8,6x)(6x,8)");
    s_assorted.add("97531");
    s_assorted.add("8b5525");
    s_assorted.add("[MA][GNU]S");
    
    samples.add(s_3trick = new Menu("3-Ball Tricks", true));
    s_3trick.add("3");
    s_3trick.add("33r");
    s_3trick.add("441");
    s_3trick.add("4r413");
    s_3trick.add("531");
    s_3trick.add("53r13r");
    s_3trick.add("612");
    s_3trick.add("52512");
    s_3trick.add("51414");
    s_3trick.add("51612");
    s_3trick.add("450");
    s_3trick.add("70701");
    s_3trick.add("801");
    s_3trick.add("17170170");
    s_3trick.add("90501");
    
    samples.add(s_4trick = new Menu("4-Ball Tricks", true));
    s_4trick.add("4");
    s_4trick.add("5r3");
    s_4trick.add("534r");
    s_4trick.add("56r1");
    s_4trick.add("6r6r1515");
    s_4trick.add("633");
    s_4trick.add("6b33");
    s_4trick.add("7531");
    s_4trick.add("7441");
    s_4trick.add("741");
    s_4trick.add("714r");
    s_4trick.add("7272712");
    s_4trick.add("61616");
    s_4trick.add("23[43]");
    s_4trick.add("912");
    s_4trick.add("10r 1 6r 1 2");
    s_4trick.add("11 0 1");
    s_4trick.add("19190");

    samples.add(s_5trick = new Menu("5-Ball Tricks", true));
    s_5trick.add("5");
    s_5trick.add("66661");
    s_5trick.add("7r57r51");
    s_5trick.add("7r57r5155");
    s_5trick.add("756r2");
    s_5trick.add("7r5625");
    s_5trick.add("8r5525");
    s_5trick.add("7r57r57r04r");
    s_5trick.add("[2t3]");
    s_5trick.add("929292912");
    s_5trick.add("14 1 10 1 6 1 2");
    
    samples.add(s_sync = new Menu("Synchronous patterns", true));
    s_sync.add("(4,2x)(2x,4)");
    s_sync.add("(6x,4x)");
    s_sync.add("(6,4x)(4x,6)");
    s_sync.add("([6r2],2)(6x,[22])(2,[6r2])([22],6x)");
    s_sync.add("([Ax2],2)(Ar,[22])(2,[Ax2])([22],Ar)");
    s_sync.add("(6,2x)(2,6x)(2x,6)(6x,2)");
    s_sync.add("(Axb,2x)(2,Abr)(2x,Abx)(Abr,2)");
    
    samples.add(s_multi = new Menu("Multiplex patterns", true));
    s_multi.add("[2t3]");
    s_multi.add("23[43]");
    s_multi.add("[31]");
    s_multi.add("25[56]25");
    s_multi.add("24[54]");
    s_multi.add("24[54]55");
    s_multi.add("25[75]5155");
    s_multi.add("21[75]");
    s_multi.add("[34]");
    
    samples.add(s_bounce = new Menu("Bounce patterns", true));
    s_bounce.add("5b");
    s_bounce.add("6b33");
    s_bounce.add("(4b,2x)(2x,4b)");
    s_bounce.add("(4,4b)(4b,4)");
    s_bounce.add("5b3");
    s_bounce.add("5b31");
    s_bounce.add("9b12");
    s_bounce.add("7b3");
    s_bounce.add("8b5525");
    s_bounce.add("10b 2 3");
    
    samples.add(s_absurd = new Menu("Absurdities", true));
    s_absurd.add("14 1 10 1 6 1 2");
    s_absurd.add("[333333333]");
    s_absurd.add("[345]");
    s_absurd.add("[34b5b]");
    s_absurd.add("123456789");
    s_absurd.add("TEAKETTLE");
    s_absurd.add("11 9 7 5 3 1");
    s_absurd.add("11b 9b 7b 5b 3b 1b");
    s_absurd.add("11b 9b 7b 5b 0 0 0 0");
    
    /* help */
    add(help = new Menu("Help"));
    setHelpMenu(help);
    help.add(about = new MenuItem("About [MA][GNU]S"));
    help.add(whomagnus = new MenuItem("Whence `[MA][GNU]S'?"));
    help.add(patternentry = new MenuItem("Pattern Entry"));
    help.add(spacetime = new MenuItem("Space-Time Diagram"));
    help.add(stategraph = new MenuItem("State Graph"));
    help.add(orbits = new MenuItem("Orbits"));
    help.add(paraminfo = new MenuItem("Parameter Info"));
    help.add(copying = new MenuItem("Copying"));
    help.add(warranty = new MenuItem("NO WARRANTY"));

    helpframe = new SlaveFrame(juggler);
    helpframe.setLayout(new BorderLayout());
    helpframe.add("Center", helptextarea = new TextArea(20, 70));
    helpframe.add("South", helpdone = new Button("Dismiss"));
    helpframe.pack();
    helptextarea.setEditable(false);
    helptextarea.setFont(new Font("System", Font.PLAIN, 14));

    /* non menu things added for getInfo, saveoptions only */
    options.addElement(new DummyOption("pattern", "Initial pattern", 
				       "String", ""));
    options.addElement(new DummyOption("bgcolor", "Background color", 
				       "int", "0"));

    options.addElement(new GeometryOption("geometry", "Juggler Window Layout", 
					  juggler, 100, 100, 330, 400));
    options.addElement(new GeometryOption("spacetimegeometry", 
					  "Space-Time Window Layout", 
					  juggler.spacetime, 
					  100, 100, 330, 150));
    options.addElement(new GeometryOption("stategraphgeometry", 
					  "State Graph Window Layout", 
					  juggler.stategraph,
					  100, 100, 330, 230));
    options.addElement(new GeometryOption("orbitsgeometry", 
					  "Orbits Window Layout", 
					  juggler.orbits,
					  100, 100, 150, 200));
    options.addElement(new GeometryOption("settingsgeometry", 
					  "Settings Window Layout", 
					  settings,
					  100, 100, 195, 264));

    Option o;
    Enumeration e = options.elements(); 
    while (e.hasMoreElements())
      {
	o = (Option)e.nextElement();
	o.getDefault(juggler);
      }
  }

public void reset(boolean windows)
  {
    Option o;
    Enumeration e = options.elements();
    while (e.hasMoreElements())
      {
	o = (Option)e.nextElement();
	if ((o instanceof GeometryOption) == windows)
	  o.reset(this);
      }
  }

public String[][] getParameterInfo()
  {
    String ans[][] = new String[options.size()][];
    Option o;
    int i = 0;
    for(Enumeration e=options.elements(); e.hasMoreElements(); ) 
      {
	o = (Option)e.nextElement();
	ans[i++] = o.getInfo();
      }
    return ans;
  }


public void saveOptions()
  {
    if (juggler.applet != null) return; // just in case 

    hotlist.saveAsHotlist();
    
    if (!saveoptions.getState()) return;

    String homedir = System.getProperty("user.home", "");
    File rc = new File(homedir, ".jugglerrc");
    File oldrc = null;
    if (rc.exists())
      {
	oldrc = new File(homedir, ".jugglerrc.old");
	if (!rc.renameTo(oldrc))
	  {
	    // error
	    juggler.message.showMessage("An error occured while trying to save options.\nOld .jugglerrc file should be intact.");
	    return;
	  }
      }
    PrintStream out;
    try
      {
	out = new PrintStream(new FileOutputStream(rc));
	boolean printgeometry = savelayout.getState();
	Enumeration e = options.elements();
	while (e.hasMoreElements())
	  {
	    Option o = (Option)e.nextElement();
	    if (printgeometry || !(o instanceof GeometryOption))
	      o.print(out);
	  }
      }
    catch (IOException e) 
      {
	//error 
	rc.delete();
	if (oldrc != null && !oldrc.renameTo(rc))
	  {
	    // error -- lost old rc
	    juggler.message.showMessage("An error occured while trying to save options. Unfortunately another\n occured trying to restore your old .jugglerrc. .jugglerrc may be lost.");
	    return;
	  }
	else
	  {
	    // restored old rc
	    juggler.message.showMessage("An error occured while trying to save options.\nOld .jugglerrc file was restored.");
	    return;
	  }
      }
    if (out != null) out.close();
  }

  // event handler 
public boolean handleEvent(Event ev)
  {
    if (ev.target == normal && ev.id == Event.ACTION_EVENT)
      {
	juggler.random(false);
	return true;
      }

    if (ev.target == random && ev.id == Event.ACTION_EVENT)
      {
	juggler.random(true);
	return true;
      }

    //    if (ev.target == sgdriven && ev.id == Event.ACTION_EVENT)
    //  {
    //    not implemented
    //	return true;
    //  }

    if (ev.target == quit && ev.id == Event.ACTION_EVENT)
      {
	juggler.quit();
	return true;
      }

    if (ev.target == fakeheights && ev.id == Event.ACTION_EVENT)
      {
	juggler.taskmaster.resetScales();
	return true;
      }

    if (ev.target == manualzoom && ev.id == Event.ACTION_EVENT)
      {
	if (manualzoom.getState())
	  {
	    bzoomout.enable();
	    lzoomout.enable();
	    lzoomin.enable();
	    bzoomin.enable();
	  }
	else
	  {
	    juggler.taskmaster.resetScales();
	    bzoomout.disable();
	    lzoomout.disable();
	    lzoomin.disable();
	    bzoomin.disable();
	  }
	return true;
      }

    if (ev.target == showsettings && ev.id == Event.ACTION_EVENT)
      {
	if (showsettings.getState())
	  settings.show();
	else
	  settings.hide();
	return true;
      }

    if (ev.target == showstategraph && ev.id == Event.ACTION_EVENT)
      {
	if (showstategraph.getState())
	  juggler.stategraph.show();
	else
	  juggler.stategraph.hide();
	return true;
      }

    if (ev.target == showspacetime && ev.id == Event.ACTION_EVENT)
      {
	if (showspacetime.getState())
	  {
	    juggler.spacetime.show();
	    st_vertical.enable();
	    st_shownumbers.enable();
	    st_scale.enable();                
	    st_width.enable();                
	    st_textoffset.enable();
	  }           
	else
	  {
	    juggler.spacetime.hide();
	    st_vertical.disable();
	    st_shownumbers.disable();
	    st_scale.disable();                
	    st_width.disable();                
	    st_textoffset.disable();
	  }
	return true;
      }

    if (ev.target == showorbits && ev.id == Event.ACTION_EVENT)
      {
	juggler.orbits.show(showorbits.getState());
	return true;
      }

    if (ev.target == st_vertical && ev.id == Event.ACTION_EVENT)
      {
	juggler.spacetime.setVertical(st_vertical.getState());
	return true;
      }

    if (ev.target == bzoomout && ev.id == Event.ACTION_EVENT)
      {
	juggler.scale.zoom(2./3.);
	return true;
      }
    if (ev.target == lzoomout && ev.id == Event.ACTION_EVENT)
      {
	juggler.scale.zoom(0.95);
	return true;
      }
    if (ev.target == lzoomin && ev.id == Event.ACTION_EVENT)
      {
	juggler.scale.zoom(1./.95);
	return true;
      }
    if (ev.target == bzoomin && ev.id == Event.ACTION_EVENT)
      {
	juggler.scale.zoom(1.5);
	return true;
      }

    if (ev.target == speed)
      {
	juggler.timer.setLogicalTimeStep((int)Math.floor(15000*Math.pow(.95,speed.getValue())));
	return true;
      }
    if (ev.target == ballsize)
      {
	ballscale = .1*Math.pow(1.25, ballsize.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == handdip)
      {
	juggler.taskmaster.handpattern.setHandDip(0.01*handdip.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == handspread)
      {
	juggler.taskmaster.handpattern.setHandSpread(0.1*handspread.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == handswing)
      {
	juggler.taskmaster.handpattern.setHandSwing(0.1*handswing.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == zoomdelay)
      {
	juggler.scale.setZoomDelay((double)zoomdelay.getValue());
	return true;
      }    
    if (ev.target == gravity)
      {
	juggler.taskmaster.setGravity(0.06*Math.pow(1.1, gravity.getValue()));
	return true;
      }
    if (ev.target == randomness)
      {
	juggler.pattern.setRandomness(0.045*randomness.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == st_scale)
      {
	juggler.spacetime.setScale(st_scale.getValue());
	return true;
      }
    if (ev.target == st_width)
      {
	juggler.spacetime.setWidth(st_width.getValue()/(double)100);
	return true;
      }
    if (ev.target == st_textoffset)
      {
	juggler.spacetime.setTextoffset(st_textoffset.getValue()/(double)350);
	return true;
      }

    if (ev.target == resetlayout && ev.id == Event.ACTION_EVENT)
      {
	reset(true);
	return true;
      }

    if (ev.target == reset && ev.id == Event.ACTION_EVENT)
      {
	reset(false);
	return true;
      }

    if (ev.target == addpattern)
      {
	Sequence tosave = history.mostRecent();
	if (tosave != null)
	  hotlist.notifyNewSequence(tosave);
	return true;
      }

    // history and hotlist
    if (ev.target instanceof UniqueHistoryItem)
      {
	MenuContainer c = ((UniqueHistoryItem)ev.target).getParent();
	if (c instanceof History)
	  return ((History)c).handleEvent(ev);
      }

    if (ev.target == helpdone && ev.id == Event.ACTION_EVENT)
      {
	helpframe.hide();
	return true;
      }

    if (ev.target == about && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("About [MA][GNU]S");
	helptextarea.setText(juggler.getAppletInfo());
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }

    if (ev.target == whomagnus && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("Whence `[MA][GNU]S'?");
	helptextarea.setText(juggler.getText("magnus.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }

    if (ev.target == patternentry && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("Pattern Entry Explained");
	helptextarea.setText(juggler.getText("patternentry.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }
    
    if (ev.target == spacetime && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("The Space-Time Window Explained");
	helptextarea.setText(juggler.getText("spacetime.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }
    
    if (ev.target == stategraph && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("The State Graph Window Explained");
	helptextarea.setText(juggler.getText("stategraph.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }
    
    if (ev.target == orbits && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("The Orbits Window Explained");
	helptextarea.setText(juggler.getText("orbits.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }

    if (ev.target == copying && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("Copying Information");
	helptextarea.setText(juggler.getText("COPYING"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }

    if (ev.target == warranty && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("NO WARRANTY");
	helptextarea.setText(juggler.getText("NO_WARRANTY.txt"));
	helptextarea.requestFocus();
	helpframe.show();
	return true;
      }

    if (ev.target == paraminfo && ev.id == Event.ACTION_EVENT)
      {
	helpframe.setTitle("Parameter Information");
	String pi[][] = getParameterInfo();
	String t = juggler.getText("params.txt");
	  
	int i =0;
	try
	  {
	    while(true)
	      {
		t=t+pi[i][0]+pi[i][1]+pi[i][2]+pi[i][3]+"\n";
		i++;
	      }
	  } catch (ArrayIndexOutOfBoundsException e) {}
	
	helptextarea.setText(t);
	helptextarea.requestFocus();
	helpframe.show(); 
	return true; 
      } 

    if (ev.id == ev.ACTION_EVENT && ev.target instanceof MenuItem)
      {
	MenuContainer mc = ((MenuItem)ev.target).getParent();
	if (mc instanceof MenuItem && ((MenuItem)mc).getParent() == samples)
	  {
	    juggler.patternentry.setText(((MenuItem)ev.target).getLabel());
	    juggler.handleEvent(new Event(juggler.patternentry, 
					  Event.ACTION_EVENT, null));
	    return true;
	  }
      }
    
    return false; // unknown event, pass it up further 
  }

public void hideTearOffs()
  {
    // AWT appears not to have a mechanism to hide torn-off menus.
    // yet another failure...

//     mode.hide();
//     view.hide();
//     samples.hide();
//     s_assorted.hide();
//     s_3trick.hide();
//     s_4trick.hide();
//     s_5trick.hide();
//     s_sync.hide();
//     s_multi.hide();
//     s_bounce.hide();
//     s_absurd.hide();
//     help.hide();           
  }  

}

