/*
 * @(#)Line.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Line.java,v 1.4 1997/03/16 19:36:18 gwar Exp $ */

//////////////////////////////////////////////////////////////////////
class Line extends SimplePath
{
  Point3 dir;  
  
public Line(Point3 start, Point3 end, double starttime, double duration)
  {
    this.starttime = starttime;
    this.endtime = starttime+duration;
    this.start = start.copy();
    this.end = end.copy();
    this.dir = new Point3();
    dir.x = (end.x - start.x)/duration;
    dir.y = (end.y - start.y)/duration;
    dir.z = (end.z - start.z)/duration;
  }

public Point3 interpolate(double now)
  {
    double deltat = now - starttime;
    Point3 ans = new Point3();
    ans.x = start.x + (dir.x*deltat);
    ans.y = start.y + (dir.y*deltat);
    ans.z = start.z + (dir.z*deltat);
    return ans;
  }
}
