/*
 * @(#)MessageWindow.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: MessageWindow.java,v 1.7 1997/03/16 19:36:19 gwar Exp $
 */

class MessageWindow extends Frame
{
  Label message, message2;
  Button dismiss;
  boolean message2added;

public MessageWindow()
  {
    setTitle("Error");
    setLayout(new BorderLayout());
    add("North", message = new Label(""));
    add("Center", message2 = new Label(""));
    message2added = true;
    add("South", dismiss = new Button("Dismiss"));
  }
    
public void setMessage(String s)
  {
    int i = s.indexOf('\n');
    if (i > -1)
      {
	message.setText(s.substring(0, i));
	s = s.substring(i+1, s.length());
	i = s.indexOf('\n');  // remove lines past 2
	if (i > -1)
	  s = s.substring(0, i);
	message2.setText(s);
	if (!message2added)
	  {
	    add("Center", message2);
	    message2added = true;
	  }
      }
    else
      {
	message.setText(s);
	if (message2added)
	  {
	    remove(message2);
	    message2added = false;
	  }
      }
    pack();
  }

public void showMessage(String s)
  {
    setMessage(s);
    show();
  }

public boolean action(Event e, Object arg)
  {
    if (e.target == dismiss)
      {
	hide();
	return true;
      }
    return false;
  }
}
