/*
 * @(#)Node.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Node.java,v 1.16 1997/03/22 05:08:47 gwar Exp $
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;

class Node
{
  Point coord;
  Point box;
  Point size;
  State st;
  boolean tall; // string placement of async labels is different if we have
  // a tall node.
  Vector edges;
  Vector labs;
  Color color;
  String label;
  boolean center;
  boolean visible;   // unimplemented and probable inadequate for edges - "51"
  boolean visited;
  int id;   /* for spectral embedding purposes */

public Node()
  {
    coord = new Point(0,0);
    box = new Point(0,0);
    size = new Point(0,0);
    tall = false;
    st = null;
    edges = new Vector(10, 2);
    labs = new Vector(4, 2);
    color = Color.black;
    label = new String("");
    visible = true;
    visited = false;
  }

public Node(State st)
  {
    coord = new Point(0,0);
    box = new Point(0,0);
    size = new Point(0,0);
    tall = false;
    this.st = st;
    this.edges = new Vector(10, 2);
    this.labs = new Vector(4, 2);
    this.color = Color.black;
    this.label = st.label();
    this.visible = true;
    this.visited = false;
    this.id = -1;
  }

public void setColor(Color col)
  {
    color = col;
  }

public void printNode()
  {
//    System.out.println(label);
    printEdges();
  }

public void printEdges()
  {
    for(Enumeration e = edges.elements(); e.hasMoreElements(); )
      {
	((Edge)e.nextElement()).printEdge();
      }
  }

public String toKey()
  {
    return label;
  }

public boolean equals(Node n2)
  {
    if(n2 == null)
      return false;

    return this.st.equal(n2.st);
  }

  // returns false if edge already exists, but it's already there so this
  // probably isn't a problem.
public boolean addEdge(Edge ed)
  {	
    if(edges.indexOf(ed) == -1)
      {
	edges.addElement(ed);
	return true;
      }
    return false;
  }
    
public boolean removeEdge(Edge ed)
  {	
    int pos;

    if((pos = edges.indexOf(ed)) > -1)
      {
	edges.removeElementAt(pos);
	return true;
      }
    return false;
  }

public void setState(State st)
  {
    this.st = st;
  }

public State getState()
  {
    return this.st;
  }

  // need to look at syn in order to know how to parse.
  // need to look into what happens when get a null string.
public Vector getLabels()
  {
    int i = 0, tmp;
    Vector vec = new Vector();
    StringBuffer strb = new StringBuffer("");
    String str = new String(label);

    // System.out.println(label);
    while(i < st.lastswi)
      {
	//System.out.println(str);
	strb.setLength(0);
	tmp = str.indexOf(st.SWITCHCHAR);
	if(tmp >= 0)
	  {
	    strb.append(str.substring(0,tmp));
	    str = new String(str.substring(tmp+1));
	  }
	else
	  {
	    strb.append(str);
	    str = new String("");
	  }
	//	if(strb.length() > 0 && strb.charAt(0) != st.SEPCHAR)
	if(strb.length() > 0)
	  vec.addElement(new StringBuffer(strb.toString()));
	i++;
      }
    //System.out.println();
    return vec;
  }

  // shouldn't return anything just set it like we are doing with tall.
public Point getNodeSize(Vector labs, FontMetrics fm)
  {
    int wid = 0;
    String str = new String(":");
    Point pl = new Point(0,0);
    boolean found = false;

    pl.y = fm.getHeight() + 4;
    for(Enumeration v = labs.elements(); v.hasMoreElements(); )    
      {
	found = true;
	str = ((StringBuffer)v.nextElement()).toString();
	//System.out.println(str);
	if(str.indexOf(State.SEPCHAR) > -1)
	  {
	    pl.x += fm.stringWidth("" + str)/2;
	    pl.y = 2*fm.getHeight() + 6;
	    tall = true;
	  }
	else
	  pl.x += fm.stringWidth("" + str);
      }

    if(!found && st.isSync())
      {
	pl.y = 2*fm.getHeight() + 6;
	tall = true;
      }

    pl.x += 10;
    //System.out.println();
    return pl;
  }

public void paint(Graphics g, Dimension d, Point ori, FontMetrics fm)
  {
    Node end;
    int w, h;
    String s0,s1,as;
    int tmp = 0;
    String str = new String();

    if(!visible)      return;

    g.setColor(color);

    if(labs.isEmpty())
      {
	labs = getLabels();
	size = getNodeSize(labs, fm);
      }

    box.x = size.x/2 + 1;
    box.y = size.y/2 + 1;

    g.fillRect(ori.x + coord.x - size.x/2, 
	       ori.y + coord.y - size.y / 2, size.x, size.y);
    g.setColor(Color.black);
    g.drawRect(ori.x + coord.x - size.x/2, 
	       ori.y + coord.y - size.y / 2, size.x-1, size.y-1);

    for(Enumeration ll = labs.elements(); ll.hasMoreElements(); )
      {
	str = ((StringBuffer)ll.nextElement()).toString();
	if(str.indexOf(st.SEPCHAR) > -1) // sync
	  {
	    s0 = new String(State.getSyncLabel(str,0));
	    s1 = new String(State.getSyncLabel(str,1));
	    g.drawString(s0, ori.x+coord.x-(size.x-10)/2 + tmp, 
			 ori.y+coord.y - (size.y-6)/2 + fm.getAscent());
	    g.drawString(s1, ori.x+coord.x-(size.x-10)/2 + tmp, 
			 ori.y+coord.y + fm.getAscent());
	    tmp += fm.stringWidth(s0);
	  }
	else
	  {
	    as = new String(State.getASyncLabel(str));
	    if(tall)
	      g.drawString(as,
			   ori.x+coord.x-(size.x-10)/2 + tmp, 
			   ori.y+coord.y - (size.y-6)/4 + fm.getAscent());
	    else
	      g.drawString(as,
			   ori.x+coord.x-(size.x-10)/2 + tmp, 
			   ori.y+coord.y - (size.y-4)/2 + fm.getAscent());
	    tmp += fm.stringWidth(as);
	  }
      }

    for(Enumeration e = edges.elements(); e.hasMoreElements(); )
      ((Edge)e.nextElement()).paint(g, d, ori, fm);
  }

public void clicked(int x, int y)
  {
  }

}
