/*
 * @(#)Option.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Option.java,v 1.8 1997/03/16 19:36:20 gwar Exp $
 */


abstract class Option
{
  String name;
  String desc;
  Object gui_component;

public String[] getInfo()
  {
    String ans[] = new String[4];
    ans[0] = padString(name, 20);
    ans[1] = padString(getType(), 9);
    ans[2] = padString(desc, 26);
    ans[3] = getValue();
    return ans;
  }

private String padString(String s, int len)
  {
    while (s.length() < len)
      s = s+" ";
    return s;
  }

public void print(PrintStream out)
  {
    out.println(name + "=" + (getValue()));
  }
  
  abstract public void reset(JugglerControls evthandler);
  abstract public void getDefault(Juggler juggler); 
  abstract public String getValue();
  abstract public String getType();
}
