/*
 * @(#)Orbits.java
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.net.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Orbits.java,v 1.5 1997/03/16 19:36:20 gwar Exp $
 */

class Orbits extends Frame
{
  Juggler juggler;

  Button done; 
  Label title;
  Image faces[];

  int len;
  String label[][];
  Thrw arrow[][];
  int face[][];
  boolean sync;
  int patTime;
  Marker ur, ll;

public Orbits(Juggler juggler)
  {
    this.juggler = juggler;
    faces = new Image[3];
    faces[0]=juggler.getImage("pics/happyface.gif");
    faces[1]=juggler.getImage("pics/overfedface.gif");
    faces[2]=juggler.getImage("pics/underfedface.gif");

    setTitle("Orbits");
    setLayout(new BorderLayout());
    add("North", ur = new Marker());
    add("South", ll = new Marker());
    resize(150,100);
  }

public void paint(Graphics g)
  {
    int x, y, w, h, i, wid, bin;
 
    g.clearRect(0, 0, size().width, size().height);
    if (patTime == 0) return;
    FontMetrics fm = g.getFontMetrics();
    int th = fm.getHeight();

    // get bounding rect of drawing space
    Rectangle rur = ur.bounds(), rll = ll.bounds();
    x = rur.x;
    y = rur.y;
    w = rll.x + rll.width - x;
    h = rll.y + rll.height - y;

    if(sync)
      {
	if (h <= 3*th) return;  /* the window is just too damn small */

	int maxu = 0, maxd = 0;          // find max length arrow
	for(i=0; i<len; i++)
	  {
	    wid = Math.abs(arrow[i][0].time - arrow[i][1].time)/2; 
	    if (wid == 0) wid = 4;
	    if (arrow[i][0].hand == arrow[i][1].hand)
	      if (arrow[i][0].hand == 0)
		{ if (wid > maxu) maxu = wid; }
	      else
		{ if (wid > maxd) maxd = wid; }
	  }
	
	bin = Math.min(8*(h-2*th)/(maxu+maxd+13), 2*w/patTime);
	x += (w - bin*patTime/2)/2;
	y += bin*(8*(h-2*th)/bin - (maxu+maxd+13))/16+th+bin*(maxu+6)/8+bin/12;

	for (i=0; i < patTime; i+=2)
	  {
	    g.drawImage(faces[face[i][0]],
			x + bin/4 + i*bin/2, y - th - 3*bin/4,
			bin/2, bin/2, this);
	    g.drawImage(faces[face[i][1]],
			x + bin/4 + i*bin/2, y + th + bin/4,
			bin/2, bin/2, this);
	    
	    wid = fm.stringWidth(label[i][0]);
	    g.setColor(Color.black);
	    g.drawString(label[i][0], x + bin/2 + i*bin/2 - wid/2, 
			 y - bin/8);
	    wid = fm.stringWidth(label[i][1]);
	    g.drawString(label[i][1], x + bin/2 + i*bin/2 - wid/2, 
			 y + bin/8 + th);
	  }

	g.setColor(Color.white);	
	for (i=0; i < len; i++)
	  {
	    if (arrow[i][0].height == 0) continue;
	    wid = Math.abs(arrow[i][0].time - arrow[i][1].time)*bin/2;
 	    if(arrow[i][0].hand != arrow[i][1].hand)  // crossing 
	      if(arrow[i][0].hand == 0)
		drawLine(g, x + bin/2 + arrow[i][0].time*bin/2,
			 y - th - bin/4,
			 x + bin/2 + arrow[i][1].time*bin/2,
			 y + th + bin/4, bin);
	      else
		drawLine(g, x + bin/2 + arrow[i][0].time*bin/2,
			 y + th + bin/4,
			 x + bin/2 + arrow[i][1].time*bin/2,
			 y - th - bin/4, bin);
	    else if(arrow[i][0].time == arrow[i][1].time)  // self 
	      if(arrow[i][0].hand == 0)
		{
		  g.drawArc(x + bin/4 + arrow[i][0].time*bin/2, 
			    y - th - 5*bin/4 +bin/32,
			    bin/2, bin/2, 250, -320);
		  drawArcArrowhead(g, x + bin/2+arrow[i][0].time*bin/2+bin/16, 
				 y-th-5*bin/4+bin/32, -bin/8, bin/6);
		}
	      else
		{
		  g.drawArc(x + bin/4 + arrow[i][0].time*bin/2, 
			    y + th + 3*bin/4 - bin/32, 
			    bin/2, bin/2, 110, 320);	      
		  drawArcArrowhead(g, x + bin/2+arrow[i][0].time*bin/2+bin/16, 
				   y+th+5*bin/4-bin/32, -bin/8, bin/6);
		}
	    else                                        
	      if(arrow[i][0].hand == 0)
		{
		  g.drawArc(x + bin/2 + 
			    Math.min(arrow[i][0].time, arrow[i][1].time)*bin/2,
			    y - th - 3*bin/4 - wid/8,
			    wid, wid/4, 180, -180);
		  if (arrow[i][0].time < arrow[i][1].time)
		    drawArcArrowhead(g, x + 3*bin/4 + 
				     (arrow[i][0].time+arrow[i][1].time)*bin/4,
				     y-th-3*bin/4-wid/8+bin/64,-bin/8, bin/6);
		  else
		    drawArcArrowhead(g, x + bin/4 + 
				     (arrow[i][0].time+arrow[i][1].time)*bin/4,
				     y-th-3*bin/4-wid/8+bin/64, bin/8, bin/6);
		}
	      else
		{
		  g.drawArc(x + bin/2 + 
			    Math.min(arrow[i][0].time,arrow[i][1].time)*bin/2, 
			    y + th + 3*bin/4 - wid/8, 
			    wid, wid/4, 180, 180);
		  if (arrow[i][0].time < arrow[i][1].time)
		    drawArcArrowhead(g, x + 3*bin/4 + 
				     (arrow[i][0].time+arrow[i][1].time)*bin/4,
				     y+th+3*bin/4+wid/8-bin/64,-bin/8, bin/6);
		  else
		    drawArcArrowhead(g, x + bin/4 + 
				     (arrow[i][0].time+arrow[i][1].time)*bin/4,
				     y+th+3*bin/4+wid/8-bin/64, bin/8, bin/6);
		}
	  }
      }
    else  // ! sync
      {
	if (h <= 2*th) return;  /* the window is just too damn small */
	
	int max = 0;
	for(i=0; i<len; i++)
	  {
	    wid = Math.abs(arrow[i][0].time - arrow[i][1].time); 
	    if (wid == 0) wid = 4;
	    if (wid > max) max = wid;
	  }
	bin = Math.min(8*(h-th)/(max+5), w/patTime);
	x += (w - bin*patTime)/2;
	y += bin*(8*(h-th)/bin - (max+5))/16 + bin*(max)/8+bin/12;

	for(i=0; i<patTime; i++)
	  {
	    g.drawImage(faces[face[i][i%2]],
			x + bin/4 + i*bin, y, 
			bin/2, bin/2, this);

	    wid = fm.stringWidth(label[i][i%2]);
	    g.setColor(Color.black);
	    g.drawString(label[i][i%2], x+bin/2+i*bin-wid/2, 
			 y+bin/2+th);
	  }
	
	g.setColor(Color.white);
	for (i=0; i < len; i++)
	  {
	    if (arrow[i][0].height == 0) continue;
	    wid = Math.abs(arrow[i][0].time - arrow[i][1].time)*bin;
	    if (arrow[i][0].time == arrow[i][1].time)
	      {
		g.drawArc(x + bin/4 + arrow[i][0].time*bin,
			  y - bin/2 + bin/32,
			  bin/2, bin/2, 250, -320);
		drawArcArrowhead(g, x + bin/2 + arrow[i][0].time*bin + bin/16, 
				 y-bin/2+bin/32, -bin/8, bin/6);
	      }
	    else
	      {
		g.drawArc(x + bin/2 + 
			  Math.min(arrow[i][0].time, arrow[i][1].time)*bin,
			  y - wid/8,
			  wid, wid/4, 180, -180);
		if (arrow[i][0].time < arrow[i][1].time)
		  drawArcArrowhead(g, x + 3*bin/4 + 
				   (arrow[i][0].time + arrow[i][1].time)*bin/2,
				   y - wid/8+bin/64, -bin/8, bin/6);
		else
		  drawArcArrowhead(g, x + bin/4 + 
				   (arrow[i][0].time + arrow[i][1].time)*bin/2,
				   y - wid/8+bin/64, bin/8, bin/6);
	      }
	  }
      }
  }

  // x,y at cusp, 
private void drawArcArrowhead(Graphics g, int x, int y, int w, int h)
  {
    g.drawLine(x, y, x+w, y+h/2);
    g.drawLine(x, y, x+w, y-h/2);
  }

private void drawLine(Graphics g, int x0, int y0, int x1, int y1, int bin)
  {
    g.drawLine(x0, y0, x1, y1);
    int vx = (x1-x0);
    int vy = (y1-y0);
    double l = (float)bin/Math.sqrt(vx*vx+vy*vy);
    vx *= l; vy *= l;
    int x = (x0+x1)/2 + vx/2;
    int y = (y0+y1)/2 + vy/2;
    g.drawLine(x, y, x-vx/8+vy/12, y-vy/8-vx/12);
    g.drawLine(x, y, x-vx/8-vy/12, y-vy/8+vx/12);
  }
  
public boolean action(Event e, Object arg)
  {
    if (e.target == done)
      {
	hide();
	return true;
      }
    return false;
  }

public void doOrbits(int patTime, int len, Thrw arrow[][], 
		      int face[][], String label[][], boolean sync)
  {
    this.len = len;
    this.arrow = arrow;
    this.face = face;
    this.sync = sync;
    this.patTime = patTime;
    this.label = label;
    
    if (juggler.controls.showorbits.getState())
      repaint();
  }

}
