/*
 * @(#)Parabola.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Parabola.java,v 1.4 1997/03/16 19:36:20 gwar Exp $
 */

//////////////////////////////////////////////////////////////////////
class Parabola extends SimplePath
{
  Point3 dir;  
  double acc;

public Parabola(Point3 start, Point3 end, double starttime, double duration, 
		double height)
  {
    this.starttime = starttime;
    endtime = starttime+duration;
    this.start = start.copy();
    this.end = end.copy();
    dir = new Point3();
    dir.x = (end.x - start.x)/duration;
    dir.y = 2*(height-start.y)/duration*
      (1+Math.sqrt((end.y-height)/(start.y-height)));
    acc = dir.y*dir.y/(4*(start.y-height));
    dir.z = (end.z - start.z)/duration;
  }
  
public Point3 interpolate(double now)
  {
    double deltat = now - starttime;
    Point3 ans = new Point3();
    ans.x = start.x + (dir.x*deltat);
    ans.y = start.y + ((dir.y + acc*deltat)*deltat);
    ans.z = start.z + (dir.z*deltat);
    return ans;
  }
}
