/*
 * @(#)Path.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Path.java,v 1.6 1997/03/16 19:36:21 gwar Exp $
 */

//////////////////////////////////////////////////////////////////////
// A path describes a trajectory in pixel space in real time. It primarily
// knows how to map a time to a point on the trajectory.
// These are given to Spriggans for them to get the place where they should
// draw themselves at a given real time.
// The different types of paths are in subclasses: eg. line, parabola, 

abstract class Path
{
  double starttime, endtime;

abstract public Point3 interpolate(double now);
abstract public Point3 end();
  
public boolean isDone(double now)
  {
    return (now>=endtime);
  }
}

