/*
 * @(#)Pattern.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.Vector;
import java.util.Random;
import java.util.Enumeration;
import java.util.BitSet;
import java.net.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Pattern.java,v 1.68 1997/04/13 23:28:49 mslevine Exp $
 */

// TODO
// 2) modified files; State, Thrw, Pattern, BallSequence, PatternParser,
// Taskmaster, Makefile
// if tmpSeq is not null, grab the next throw from there.  
// 3) need method that will take a BallSequence of throws and see if they are
// valid from the current state
// 4) shouldn't initParity be called from initState?

//////////////////////////////////////////////////////////////////////////
// the pattern is stored as an array of throws, where each throw is given by
// its height, the hand that does it, the logical time it should happen, 
// and whether it crosses. this hopefully makes pattern general enough to 
// handle synchronous throws, multiplexes, and crossing throws
// this class has not been written with more than 2 hands in mind.
// note that to remove a ball during a pattern transition it should be told 
// to do a negative throw (Allen prefers this to zero, as he'd like to output
// an error if a real ball is every told to do a zero)
class Pattern
{
  static private boolean DBG = false;

  private Juggler juggler;
  PatternParser   parser;

  // these variables are for steady state
  private int cnt[];           // count of throws done so far at time (by hand)
  public int time;             // current time

  // these keep track of the actual throws to use.  when a transition is
  // requested, the new pattern goes into nextSeq.  the transition throws
  // are put into tmpSeq.  After everything is calculated, curSeq = newSeq.
  BallSequence curSeq;
  BallSequence newSeq;

  State curSt;                 // what's already in the air and falling
  State newSt;
  
  boolean randomPattern = false;
  double randomness = .5;   // probability that suggestion will be rejected
  Random rnd;

  Vector curThrws[];        // the only valid fields are height and mods.
                            // deal.  i wanted an object and needed both.
                            // don't know if above is still true.

  // flag to alert that pattern has received a new sequence.  in
  // particular, this is currently used to alert Juggler that it needs to sort
  // regardless of what seq.multi and seq.holds say, because no sorting has
  // done yet.
  boolean dirty;            
 
  public Pattern(Juggler j)
    {
      juggler = j;
      parser = new PatternParser();

      curSeq = new BallSequence();  // initialize default pattern
      
      cnt = new int[2];
      cnt[0] = cnt[1] = 0;
      time = -1;   // MAGIC...

      curSt = curSeq.initState();

      dirty = true;
      rnd = new Random();
      curThrws = new Vector[2];
      curThrws[0] = new Vector(6,1);
      curThrws[1] = new Vector(6,1);
    }

  // transTime is 0 if not transitioning
  private int setStarttime(int transTime )
    {
      newSeq.startt = curSeq.startt + transTime;
      if(curSt.syn[Math.max(curSt.lastswi-1,0)] != newSeq.isSync()) {
	if(transTime > 0) 
	  newSeq.startt++;
      }
      else
	if(transTime == curSt.swi[curSt.lastswi] && 
	   !curSt.syn[Math.max(curSt.lastswi-1,0)] && !newSeq.isSync())
	  {
	    if((curSt.lastLand[0] == curSt.swi[curSt.lastswi] - 1 && 
		newSt.landAt[0][0] != -1) ||
	       (curSt.lastLand[1] == curSt.swi[curSt.lastswi] - 1 && 
		newSt.landAt[1][0] != -1))
	      newSeq.startt++;
	  }
      curSeq.endt = newSeq.startt - 1;
      return newSeq.startt;
    }

  // force all the balls to be thrown from transthrws.  there are some
  // instances where you could make the transition more efficiently, but
  // this should be less error prone.
  private int findTransTime()
    {
      int tmpLast; // shiftState changes the value of st.maxLastLand
      int len = 0;
      boolean ev;
      State tempOld = curSt.copy(curSt.maxHeight);

      // sync <--> async
      // we don't want to let the current state be a subset because then 
      // a hand could be expected to throw in two successive beats.
      if(tempOld.syn[Math.max(tempOld.lastswi-1,0)] != newSt.isSync())
	{
	  while(tempOld.countBalls() > 0)  // there is a ball landing
	    {
	      tempOld.shiftState(1,false);
	      len++;
	    }
	  if (DBG) System.out.println("sync <--> newsync transTime: "+len);
	  return len;
	}

      // step through until our state is a subset.
      while(len <= curSt.swi[curSt.lastswi] - 1 && 
	    State.isSubset(tempOld, newSt) == false)
	{
	  tempOld.shiftState(1, false);
	  len ++;
	}

      if(curSt.syn[Math.max(tempOld.lastswi-1,0)] && newSt.isSync() &&
	 (curSt.swi[curSt.lastswi] - 1 + len) % 2 == 1)
	{
	  tempOld.shiftState(1, false);
	  len ++;
	}

      // async --> async
      // don't want to throw even crossing
       if(!curSt.syn[Math.max(curSt.lastswi-1,0)] && !newSt.isSync())
 	{
	  if((curSt.par[Math.max(curSt.lastswi-1,0)] + curSt.offset + len + 
	      newSt.eve()) % 2 == 1)
	    {
	      if(DBG)
		System.out.println("..............helllllllllllo...........");
	      tempOld.shiftState(1, false);
	      len ++;
	    }
	}

      if(DBG)   System.out.println("transTime is: " + len);
      return len;
    }  // findTransTime

  // return vector of thrws for new balls
  public Vector transitionTo()
    {
      Vector ans = null, avail, holes;
      BallSequence tmpSeq;
      int transTime, oldnumballs, thrwDiff, tmpTime;
      
      oldnumballs = curSt.countBalls();
      
      if(DBG) 
	{
	  System.out.print("oldnum: "+oldnumballs+"     ");
	  System.out.println("newnum: "+newSeq.numballs);
	}

      if(oldnumballs == 0 && newSeq.numballs == 0 &&
	 (curSeq.isSync() == newSeq.isSync()))
	{
	  ans = new Vector(1);
	  return ans;
	}

      tmpSeq = new BallSequence(oldnumballs, false);
      tmpSeq.startt = time +1;
      tmpSeq.looping = false;
      tmpSeq.setSync(curSeq.isSync());
      curSeq = tmpSeq;
      
      newSt = newSeq.initState();  // needs to be done after numballs is set
      tmpTime = transTime = findTransTime();
      setStarttime(transTime);
      transTime = newSeq.startt - time;
      
      if(curSt.syn[Math.max(curSt.lastswi-1,0)] != newSt.isSync())
	if(curSt.lastswi != 0)
	  {
	    curSt.swi[curSt.lastswi+1] = curSt.swi[curSt.lastswi];
	    curSt.swi[curSt.lastswi] = newSeq.startt - curSeq.startt;
	    curSt.syn[curSt.lastswi] = newSeq.isSync();
	    curSt.syn[curSt.lastswi+1] = curSt.syn[curSt.lastswi];
	    curSt.lastswi++;
	  }
	else
	  {
	    curSt.lastswi = 2;
	    curSt.swi[0] = 0;
	    curSt.swi[1] = newSeq.startt - curSeq.startt;
	    curSt.swi[2] = newSeq.startt - curSeq.startt;
	    curSt.syn[1] = newSeq.isSync();
	    curSt.syn[2] = newSeq.isSync();
	  }

      if(DBG) System.out.println("transstarttime is: "+curSeq.startt);
      if(DBG) System.out.println("starttime is: "+newSeq.startt);

      // not yet implemented
      //   if((thrwDiff = BallSequence.sameSequence(curSeq, newSeq, true)) > -1)
      //    {	
      //      transToSameSequence(thrwDiff, tmpSeq);
      //      if(DBG) System.out.println("doing transition to same pattern");
      //    }  
      //    else
      //    {

      // find places we can make transition
      // balls to or add new balls at
      holes = State.findHoles(curSt, newSt, newSeq.numballs, tmpTime);

      // find balls to use for transthrws
      avail = curSt.findAvail(holes.size()+
                              Math.max(oldnumballs-newSeq.numballs,0), tmpTime);
      
      // here is the actual meat of this method.
      nukeBalls(Math.max(oldnumballs-newSeq.numballs,0), avail, tmpSeq);
      addTransThrows(holes.size(), avail, holes, tmpSeq);
      ans = addBalls(Math.max(newSeq.numballs - oldnumballs,0), holes);

      // we don't need curSeq anymore as we are going to immediately start 
      // grabbing throws from tmpSeq and then go on to newSeq.
      if(curSeq.len <= 0)
	{
	  curSeq = newSeq;
	  dirty = true;
	  juggler.taskmaster.resetScales();
	  curSt.setSync(curSeq.isSync());
	}

      cnt[0] = cnt[1] = 0;

      if(DBG) System.out.println(curSt.label()+ " "+curSt.landingList());      
      return ans;
    } // transitionTo
  
  // returns number of holes avail.  modifies avail vector.
  private int nukeBalls(int maxNeeded, Vector avail, BallSequence tmpSeq)
    {
      int i=0, nTime;
      BitSet imp = new BitSet(4);
      BitSet exp = new BitSet(4);

      imp.set(Thrw.THR);
      for(i=0; i < maxNeeded && avail.size() > 0; i++)
	{
	  nTime = ((Place)avail.elementAt(0)).time();
	  tmpSeq.ths[tmpSeq.len++] = 
	    new Thrw(-1, ((Place)avail.elementAt(0)).hand(),nTime, exp, imp);
	  avail.removeElementAt(0);
	}
      return i;
    } // nukeBalls

  // returns balls to be added.  modifies holes vector.
  private Vector addBalls(int maxNeeded, Vector holes)
    {
      int i=0, aTime;
      Vector ans = new Vector(Math.max(maxNeeded,1));

      while(i < maxNeeded && holes.size() > 0)
	{
	  aTime = ((Place)holes.elementAt(0)).time() + newSeq.startt 
	    - curSeq.startt;
	  if(DBG)
	    System.out.println("added ball; hand: "+
	      ((Place)holes.elementAt(0)).hand()+" time: "+aTime);
	  ans.addElement(new Thrw(0, ((Place)holes.elementAt(0)).hand(),
				  aTime));
	  // need to add ball to landing state
	  curSt.addLanding(((Place)holes.elementAt(0)).hand(), aTime, true);
	  holes.removeElementAt(0);
	  i++;
	}
      return ans; // size contains how many balls were actually added
    } // addBalls

  // thrwDiff is the number of throws before the pattern is aligned with
  // the new pattern.  ie, the next throw should be the first throw of the
  // new pattern.  note that we are not updating 'holes' or 'avail'.  this 
  // shouldn't be a problem as this method should only be called when no 
  // balls need to be added or removed.
  private void transToSameSequence(int thrwDiff, BallSequence tmpSeq)
    {	
      int start = newSeq.len - thrwDiff;

      for(int i=0;i<thrwDiff; i++)
	tmpSeq.ths[tmpSeq.len++] = newSeq.ths[(start+i)%newSeq.len].copy();
    }  // transToSameSequence

  // fill up holes with available balls.  removes entries from holes
  // and avail as this function might be called before addBalls and 
  // nukeBalls
  private int addTransThrows(int maxNeeded, Vector avail, 
			     Vector holes, BallSequence tmpSeq)
    {
      int hgt, i;
      newSeq.crossingkludge = false;
      BitSet imp = new BitSet(4);
      BitSet exp = new BitSet(4);

      for(i=0;i<maxNeeded && holes.size() > 0 && avail.size() > 0; i++)
	{
	  imp.clear(Thrw.CRO);
	  imp.clear(Thrw.THR);
	  exp.clear(Thrw.CRO);
	  hgt = (newSeq.startt + ((Place)holes.elementAt(0)).time()) - 
	    (curSeq.startt + ((Place)avail.elementAt(0)).time());
	  if((((Place)avail.elementAt(0)).hand() != 
	      ((Place)holes.elementAt(0)).hand()))
	    {
	      if (curSeq.isSync())
		exp.set(Thrw.CRO);
	      else 
		imp.set(Thrw.CRO);
	    }
	  if (hgt != 0 && hgt != 2)
	    imp.set(Thrw.THR);
	  tmpSeq.addThrow(new Thrw(hgt, ((Place)avail.elementAt(0)).hand(), 
				   ((Place)avail.elementAt(0)).time(), 
				   exp, imp));
	  holes.removeElementAt(0);
	  avail.removeElementAt(0);
	}
      
      return i;
    }  // addTransThrows

  public void nextSequence()
    {
      if (DBG) System.out.println("changing seqs");
      if(newSeq == null)
	{
	  if(DBG) System.out.println("ERROR: no sequence to transition to");
	  return;
	}

      dirty = true;
      curSeq = newSeq;
      newSeq = null;
      if(DBG) curSeq.printSequence();

      juggler.taskmaster.resetScales();
      curSt.setSync(curSeq.isSync());
    }

  public void setRandomness(double ran)
    {
      randomness = ran;
    }

  public boolean noBalls()
    {
      if(curSt.swi[curSt.lastswi] == 0)
	return true;
      else
	return false;
    }

  public void toggleRandom()
    {
      if (randomPattern)
	{
	  randomPattern = false;
	}
      else
	{
	  randomPattern = true;
	  newSeq = curSeq;
	  dirty = true;
	}
    }

public void clearMovement()
  {
    curThrws[0].removeAllElements();
    curThrws[1].removeAllElements();
  }

public BallSequence evenOutSequence(BallSequence seq)
  {
    BallSequence tmpSeq = seq.copy(2*seq.len);

    for(int i = 0; i < seq.len; i++)
      tmpSeq.ths[seq.len+i] = seq.ths[i].copy();
    return tmpSeq;
  }

private Thrw nextRandomThrw(int hand, int logtime)
    {
      Place pl;
      int count = 1, hgt;
      Thrw th;
      BitSet imp = new BitSet(4);
      BitSet exp = new BitSet(4);

      while(rnd.nextDouble() < randomness)
	count++;

      pl = curSt.nthEmpty(count); // time of 0 corresponds to throw of 1
      if(DBG) System.out.println("accepted throw to hand: "+
				 pl.hand()+" time: "+pl.time());
      hgt = pl.time() + 1;
      if((hgt%2 == 1) || (curSt.isSync() && hand != pl.hand()))
	if(curSt.isSync())
	  exp.set(Thrw.CRO);
	else
	  imp.set(Thrw.CRO);

      if(hgt != 2 || (curSt.isSync() && hand != pl.hand()))
	imp.set(Thrw.THR);
	 
      curSt.addLanding(pl.hand(), pl.time(), true);
      curThrws[hand].addElement(new Thrw(hgt, hand, logtime,exp, imp));

      th = new Thrw(hgt, pl.hand(), logtime + hgt, exp, imp);

      if(DBG) th.printThrow();

      return th;
    }

public Thrw nextThrw(int landinghand, int logtime)
    {
      int i, j;
      Thrw ans;
      
      if (randomPattern)
	return nextRandomThrw(landinghand, logtime);

      if (!curSeq.looping)
	{
	  int tm = time-curSeq.startt;
	  for(i=0, j=0; i<curSeq.len && j<=cnt[landinghand]; i++) 
	    if (curSeq.ths[i].time == tm && curSeq.ths[i].hand == landinghand)
	      j++;
	  i--;
	  cnt[landinghand]++;
	  ans = curSeq.ths[i].copy();
	}
      else
	{
	  int tm = (time - curSeq.startt) % curSeq.timediff;

	  boolean evenpass = curSeq.isSync() ||
	    (((((time-curSeq.startt) / curSeq.timediff)*curSeq.timediff) % 2) == 0);
	  int hnd = 1;
	  if ((landinghand == 0 && evenpass) || (landinghand == 1 && !evenpass))
	    hnd = 0;

	  for(i=0, j=0; i<curSeq.len && j<=cnt[hnd]; i++) 
	    if (curSeq.ths[i].time == tm && curSeq.ths[i].hand == hnd) j++;
	  i--;
	  cnt[hnd]++;
	  ans = curSeq.ths[i].copy();    
	}

      curThrws[landinghand].addElement(
	      new Thrw(ans.height, landinghand, logtime,
		       ans.exp, ans.imp));

      if (ans.isCro())     
	ans.hand = 1 - landinghand;
      else ans.hand = landinghand;

      ans.time = logtime + Math.max(ans.height,0);

      // currently can add a landing for a 0 height throw, not sure how this
      // will eventually work if indeed we want it to.
      if (ans.height > 0)
	curSt.addLanding(ans.hand, ans.height-1, ans.height != 0);

      if(ans.height == -1)
	curSeq.numballs--; 

      //ans.printThrow();
      return ans;

    } // nextThrw

  public int maxThrwForZoom()
    {
      if(randomPattern == true)
	{
	  int act = (int) (1.2/(1-randomness));
	  return (act + curSeq.numballs);  //magic 1.2
	}
      if(!curSeq.looping && newSeq != null) 
	return newSeq.maxThrwHeight(true);
      else
	return curSeq.maxThrwHeight(true);
    }

  public boolean hasBounces()
    {
      boolean ans = false;
      BallSequence seq;

      if(!curSeq.looping && newSeq != null) 
	seq = newSeq;
      else
	seq = curSeq;

      for(int i=0; i<seq.len && !ans; i++)
	ans = (seq.ths[i].isBou());
      return ans;
    }

  public boolean hasReverses()
    {
      boolean ans = false;
      BallSequence seq;

      if(!curSeq.looping && newSeq != null) 
	seq = newSeq;
      else
	seq = curSeq;

      for(int i=0; i<seq.len && !ans; i++)
	ans = (seq.ths[i].isRev());
      return ans;
    }

  // should the hand move? yes iff there is a >2 throw to do
  public boolean shouldHold(int hand)
    {
      for(Enumeration e = curThrws[hand].elements(); e.hasMoreElements(); )
	if (((Thrw)e.nextElement()).isThr())
	  return false;

      return true;
    }

  // hand has a thrown non-1 ?
  public boolean oneOnly(int hand)
  {
    for(Enumeration e = curThrws[hand].elements(); e.hasMoreElements(); )
      {
	Thrw th = (Thrw) e.nextElement();
	if (th.height != 1 && th.isThr()) 
	  return false;  
      }
    return true;
  }

  // assumes pattern parser does right thing.
  public boolean reverseThrow(int hand)
    {
      return(((Thrw)(curThrws[hand].firstElement())).isRev());
    }

  public boolean handHasZero(int hand)
    {
      for(Enumeration e = curThrws[hand].elements(); e.hasMoreElements(); )
	return false;  // hand actually has a throw

      return true;
    }

  public void incrTime(int logtime)
    {
      if(time > logtime)
	{
	  System.out.println("time is bigger than logtime in incrTime");
	  return;
	}
      if (time == logtime) return;

      if (!curSeq.looping && logtime > curSeq.endt && !randomPattern)
	nextSequence();

      // WARNING this should be put in state
      if(juggler.controls.showstategraph.getState() &&
	 (!curSt.isSync() || !throwingNow(0,logtime)))
	juggler.stategraph.newJugglerState(curSt, copyCurThrws());

      curSt.shiftState(1, true);
      time++;

      if(time != 0)
	{
	  clearMovement();
	  cnt[1] = cnt[0] = 0;  
	}
    }

  // make sure to copy them as they'll change
  public Vector copyCurThrws()
  {
    Vector ths = new Vector(5,1);

    for(int i=0; i<2; i++)
      for(Enumeration e = curThrws[i].elements(); e.hasMoreElements(); )
	ths.addElement(((Thrw) e.nextElement()).copy());

    return ths;
  }

  public String getHandLabel(int hand)
    {
      String ans = "";
      Thrw t;

      Enumeration e = curThrws[hand].elements();
      while (e.hasMoreElements())
	{
	  t = (Thrw)e.nextElement();
	  if (t.height >= 0)
	    {
	      ans += String.valueOf(t.height);
	      ans += t.getStr(t.exp);
	      ans += " ";
	    }
	  else 
	    ans += "d ";
	}
      
      ans = ans.trim();
      if (ans.compareTo("") == 0) ans = "0";

      return ans;
    }
  
  // this is a big hack to tell whether a zero should be labeled in 
  // spacetime or not   
  public boolean throwingNow(int hand, int logtime)
  {
    int fudge;
    int seqpar;

    if(!curSeq.isSync()) {
      seqpar = (curSeq.ths[0].hand + curSeq.ths[0].time) % 2;
      return ((seqpar + logtime - curSeq.startt + 2) % 2 == hand);
    }
    else {
     return ((logtime - curSeq.startt + curSeq.ths[0].time)%2 == 0);
    }
  }

public boolean addSeq(String str)
  {
    BallSequence tmpSeq;
      
    tmpSeq = (BallSequence)parseString(str);
    //tmpSeq.printSequence();
    if (tmpSeq == null) return false;
    newSeq = tmpSeq;
    return true;
  }

public Sequence parseString(String str)
  {
    BallSequence tmpSeq;
      
    // str.length() is upper bound on num new throws
    tmpSeq = new BallSequence(str.length(), true);

    if (!parser.parseString(str, tmpSeq)) 
      return null;      // syntactically incorrect
    tmpSeq.name = str;
    tmpSeq.massage();   // put into nice form.
    if(!tmpSeq.validate(juggler.orbits))
      return null;      // syntactically okay, semantically incorrect

    if(DBG) System.out.println("added Pattern "+str);

    tmpSeq.calcParams();
    tmpSeq.numballs = tmpSeq.countBalls();

    return tmpSeq;
  }


}

