/*
 * @(#)SGControls.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 */

/////////////////////////////////////////////////////////////////////////
// SGControls holds the UI objects for user control of the state graph
// it is a child of the StateGraph (in the AWT sense), so getParent()
// can be used to fetch the current StateGraph object and send it messages
// to change state
class SGControls extends Frame
{
  StateGraph sg;

  Checkbox vanillaentry;
  Checkbox useoneforx;
  Checkbox grabstates;

  Scrollbar fontsize;

  Button clearall;
  Button clearirrelevant;
  Button expandcompound;
  Button done;
  
  Panel checks, labels, sliders, buttons;

public SGControls(StateGraph sg)
  {
    this.sg = sg;
    String str;

    setTitle("State Graph Settings");
  
    setLayout(new BorderLayout());

    checks = new Panel();
    checks.setLayout(new GridLayout(3,1));

    boolean bval;

    str = juggler.getParameter("vanillaentry");
    bval = true;
    if (str != null && !Boolean.valueOf(str).booleanValue()) bval = false;
    checks.add("1", vanillaentry = new Checkbox("vanillaentry", null, bval));

    str = juggler.getParameter("useoneforx");
    bval = false;
    if (str != null && Boolean.valueOf(str).booleanValue()) bval = true;
    checks.add("2", useoneforx = new Checkbox("Use '1' for 'x'", null, bval));

    str = juggler.getParameter("grabstates");
    bval = false;
    if (str != null && Boolean.valueOf(str).booleanValue()) bval = true;
    checks.add("3", grab states = new Checkbox("Grab States",   null, bval));

    add("North", checks);

    labels = new Panel();
    labels.setLayout(new GridLayout(1,1));
    labels.add("1", new Label("Font Size"));




    add("West", labels);

    add("South", done = new Button("Done"));

    sliders = new Panel();
    sliders.setLayout(new GridLayout(8,1));
    int val;
    str = juggler.getParameter("speed");
    val = 34;
    if (str != null)
      val = Integer.valueOf(str).intValue();
    if (val < 7) val = 7;
    if (val > 70) val = 70;
    sliders.add("1", speed = new Scrollbar(Scrollbar.HORIZONTAL, val, 6, 7, 
					   70));
    juggler.timer.setLogicalTimeStep(30*(77-speed.getValue()));

    str = juggler.getParameter("ballsize");
    val = 0;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) { }
    if (val < -7) val = -7;
    if (val > 7) val = 7;
    sliders.add("2", ballsize = new Scrollbar(Scrollbar.HORIZONTAL, val, 1, -7,
					      7));
    ballscale = .1*Math.pow(1.25, ballsize.getValue());

    str = juggler.getParameter("handdip");
    val = 10;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < 1) val = 1;
    if (val > 30) val = 30;
    sliders.add("3", handdip = new Scrollbar(Scrollbar.HORIZONTAL, val, 5, 1, 
					     30));
    juggler.taskmaster.handpattern.setHandDip(0.01*handdip.getValue());

    str = juggler.getParameter("handspread");
    val = 5;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < -15) val = -15;
    if (val > 15) val = 15;
    sliders.add("4", handspread = new Scrollbar(Scrollbar.HORIZONTAL, val, 3, 
					      -15, 15));
    juggler.taskmaster.handpattern.setHandSpread(0.1*handspread.getValue());
	
    str = juggler.getParameter("handswing");
    val = 6;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < 0) val = 0;
    if (val > 15) val = 15;
    sliders.add("5", handswing = new Scrollbar(Scrollbar.HORIZONTAL, val, 3,
					       0, 15));
    juggler.taskmaster.handpattern.setHandSwing(0.05*handswing.getValue());

    str = juggler.getParameter("zoomdelay");
    val = 3;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < 0) val = 0;
    if (val > 10) val = 10;
    sliders.add("6", zoom = new Scrollbar(Scrollbar.HORIZONTAL, val, 2, 0, 
					     10));
    juggler.scale.setZoomDelay((double)zoom.getValue());

    str = juggler.getParameter("gravity");
    val = 5;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < 1) val = 1;
    if (val > 25) val = 25;
    sliders.add("7", gravity = new Scrollbar(Scrollbar.HORIZONTAL, val, 3, 1, 
					     25));
    juggler.taskmaster.setGravity(0.2*gravity.getValue());

    str = juggler.getParameter("randomness");
    val = 10;
    if (str != null)
      try {
	val = Integer.valueOf(str).intValue();
      } catch (NumberFormatException e) {}
    if (val < 1) val = 1;
    if (val > 20) val = 20;
    sliders.add("8", randomness = new Scrollbar(Scrollbar.HORIZONTAL, val, 10, 1, 
					     20));
    juggler.pattern.setRandomness(0.05*randomness.getValue());

    add("Center", sliders);

    pack();
  }

  // event handler 
public boolean handleEvent(Event ev)
  {
    // note most checkboxes handled automatically...

    if (ev.target == fakeheights && ev.id == Event.ACTION_EVENT)
      {
	juggler.taskmaster.setFakeHeights(fakeheights.getState());
	return true;
      }

    if (ev.target == speed)
      {
	juggler.timer.setLogicalTimeStep(30*(77-speed.getValue()));
	return true;
      }
    if (ev.target == ballsize)
      {
	ballscale = .1*Math.pow(1.25, ballsize.getValue());
	return true;
      }
    if (ev.target == handdip)
      {
	juggler.taskmaster.handpattern.setHandDip(0.01*handdip.getValue());
	return true;
      }
    if (ev.target == handspread)
      {
	juggler.taskmaster.handpattern.setHandSpread(0.1*handspread.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == handswing)
      {
	juggler.taskmaster.handpattern.setHandSwing(0.1*handswing.getValue());
	juggler.taskmaster.resetScales();
	return true;
      }
    if (ev.target == zoom)
      {
	juggler.scale.setZoomDelay((double)zoom.getValue());
	return true;
      }    
    if (ev.target == gravity)
      {
	juggler.taskmaster.setGravity(0.2*gravity.getValue());
	return true;
      }
    if (ev.target == randomness)
      {
	juggler.pattern.setRandomness(0.05*randomness.getValue());
	return true;
      }
    if (ev.target == done && ev.id == Event.ACTION_EVENT)
      {
	hide();
	return true;
      }
    return false;    // unknown event, pass it up further
  }

}
