/*
 * @(#)Scale.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Scale.java,v 1.15 1997/03/22 04:37:35 mslevine Exp $
 */

//////////////////////////////////////////////////////////////////////
// this is responsible for the mapping from logical space to pixels
// logical space is a right side up (y up) right handed coordinate system 
// perspective transforms belong here if we ever use real 3D
class Scale
{
private Point org, oorg, curorg;
private double scale, oscale, cscale;
private double manscale=1.;
private Rectangle bounds;
private double xsiz=1., ydown=.5, yup=41./50.;
private double delayfactor=0.;
private double starttime, endtime;
private Juggler juggler;
private String msg;

public Scale(Juggler j)
  {
    juggler = j;
    org = new Point(0,0);
    oorg = new Point(0,0);
    curorg = new Point(0,0);
    bounds = new Rectangle(0,0,10,10);
  }
  
public void setZoomDelay(double delayfactor)
  {
    double nw = juggler.timer.now();
    if (nw < endtime)
      {
	double dt = (nw - starttime)/(endtime-starttime);
	oorg.x += (org.x-oorg.x)*dt; 
	oorg.y += (org.y-oorg.y)*dt; 
	oscale += (scale-oscale)*dt;
	endtime = nw+delayfactor*(endtime-nw)/this.delayfactor;
	starttime = nw;
      }
    this.delayfactor = delayfactor;
  }

public void resize(Rectangle bounds)
  {
    endtime = juggler.timer.now();
    this.bounds = bounds;
    double ysiz = yup+ydown;    
    org.x = bounds.x+bounds.width/2;
    if (ysiz/xsiz >= bounds.height/(double)bounds.width) 
      scale = bounds.height/ysiz;
    else scale = bounds.width/xsiz;
    org.y = bounds.y+bounds.height-(int)(scale*ydown);
    scale *= manscale;
  }

public void zoom(double factor)
  {
    endtime = juggler.timer.now();
    manscale *= factor;
    scale *= factor;
    if (!juggler.running) 
      {
	setDrawTime(juggler.timer.now());
	juggler.repaint();
      }
  }

public void setScale(double xsiz, double ydown, double yup)
  {
    starttime = juggler.timer.now();
    this.xsiz = xsiz;
    this.ydown = ydown;
    this.yup = yup;
    endtime = starttime+delayfactor;
    oorg.x = curorg.x;
    oorg.y = curorg.y;
    oscale = cscale;

    double ysiz = yup+ydown;    
    org.x = bounds.x+bounds.width/2;
    if (ysiz/xsiz >= bounds.height/(double)bounds.width) 
      scale = bounds.height/ysiz;
    else scale = bounds.width/xsiz;
    org.y = bounds.y+bounds.height-(int)(scale*ydown);

    if (scale > oscale)  msg = "Zooming in...";
    if (scale < oscale) msg = "Zooming out...";
    juggler.showStatus(msg, false);
  }  

public void setDrawTime(double now)
  {
    if (now >= endtime)
      {
	if (msg != null)
	  {
	    msg = null;
	    juggler.showStatus("", false);
	  }
	curorg.x = org.x;
	curorg.y = org.y;
	cscale = scale;
      }
    else
      {
	double dt = (now - starttime)/(endtime-starttime);;
	curorg.x = (int)(oorg.x+(org.x-oorg.x)*dt);
	curorg.y = (int)(oorg.y+(org.y-oorg.y)*dt);
	cscale = oscale+(scale-oscale)*dt;
      }
  }

public int scaleToPixels(double val)
  {
    return (int)(val*cscale);
  }
    
public Point mapToPixels(Point3 p)
  {
    Point ans = new Point(0,0);     // z gets pitched cause we only do 2.5D
    ans.x = curorg.x + (int)(p.x*cscale);
    ans.y = curorg.y - (int)(p.y*cscale);
    return ans;
  }
}
