/*
 * @(#)Spriggan.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Spriggan.java,v 1.12 1997/03/22 03:14:40 gwar Exp $
 */


//////////////////////////////////////////////////////////////////////////
// "Spriggan" (since sprite is probably someone's trademark)
//	This knows how to draw itself, periodically realizes that it's
//	done with its current task and knows who to ask for another,
//	and maybe should run as its own thread??
abstract class Spriggan 
{          
  Point3 pos;              // position
  CompoundPath path;       // current path to follow
  Juggler juggler;   // taskmaster to get new path from
  Color color;             
  int lastscale=2;

  abstract public void paint(Graphics g);

  // move object. returns true if ok, false if it should die.
public boolean move(double now)
  {
    return true;
  }

  protected void init()  // do initialization (constructors aren't inherited)
  {
    pos = new Point3();
    path = new CompoundPath(0, 0);  // this will always have isDone() true
  }

public void setColor(Color color)
  {
    this.color = color;
  }

public Point3 position()
  {
    return pos;
  }

public int logendtime()
  {
    return 0;
  }

  // want balls that don't effect hand movement last.
  // want hands first
public int compare(Spriggan s1)
  {
    if(this instanceof Ball)
      {
	boolean mod1 = ((Ball)this).thrw.isThr();
	if(s1 instanceof Ball)
	  {
	    boolean mod2 = ((Ball)s1).thrw.isThr();

	    if(mod1 && !mod2)
	      return 1;
	    else if (mod2 && !mod1)
	      return -1;
	    else
	      return 0;
	  }
	if(s1 instanceof Hand)
	  return 1;
      }
    if (this instanceof Hand && s1 instanceof Ball) return -1;
    return 0;
  }
}
