/*
 * @(#)TaskMaster.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.Vector;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Taskmaster.java,v 1.47 1997/04/13 23:27:47 mslevine Exp $
 */

//////////////////////////////////////////////////////////////////////
// "Taskmaster"
// This object basically knows about screen layout.
// It is the intermediate between the spriggans, whichonly know how to draw
// themselves, and the pattern, which only deals with the mathematical
// view of juggling
// Spriggans contact the taskmaster when their current path runs out.
// The taskmaster then asks the pattern what should happen next and creates
// an appropriate path to give back to the spriggan.
// Note that the current implementation does go right at the variables of
// both sppriggans and throws.
//
// It will need major retooling to supprt more than 2 hands. Don't even try.
//
// Semi-support for interesting hand motions has been moved to HandPattern
class Taskmaster
{
  static boolean DBG = false;
  Juggler juggler;
  Dimension size;             // size in pixels of display window
  double baseheight, heightperball, gravity, floor;
  HandPattern handpattern;

public Taskmaster(Juggler juggler)
  {
    this.juggler = juggler;
    handpattern = new HandPattern();
    juggler.scale.setScale(2*handpattern.handspread+.21, 
			   handpattern.handdip+.1,  2.25);
  }

public void setGravity(double g)
  {
    gravity = g;
    resetScales();
  }

public void resetScales()
  {
    if (juggler.controls == null) return;  /* too early */
    
    if (juggler.pattern.hasBounces()) floor = -1.;
    else floor = -handpattern.handdip-.25;

    int max = juggler.pattern.maxThrwForZoom()-1;
    if (max <= 0) max = 4;
    if (max < 3) max = 3;
    double up;
    if (juggler.controls.fakeheights.getState())
      {
	up = 0.5*max*gravity+juggler.controls.ballscale;
	heightperball = 0.45*gravity;
      }
    else
      {
	up = 0.15*max*max*gravity+juggler.controls.ballscale;
	heightperball = 0.14*gravity;
      }
    double width;
    double rev = 0.;
    if (juggler.pattern.hasReverses()) rev = handpattern.handswing;
    width = 2.*(Math.abs(handpattern.handspread)+rev) + 
      Math.max(.2, juggler.controls.ballscale)+0.01;
    if (!juggler.controls.manualzoom.getState()) 
      juggler.scale.setScale(width, -floor, up);
    handpattern.setLength(2*max);
    baseheight = 0;     // 0 is the best for zooming purposes...
  }

public void initBall(Ball s, Thrw thr, double startt)
  {
    s.thrw = thr;
    s.label = "*";
    double end = Math.ceil(startt);
    int start = (int)end;
    end += s.thrw.time;
    s.thrw.time += start;
    if(DBG)
      {
        System.out.print("in ball init: "+thr.time+" end: "+end);
        System.out.println(" startt: "+startt);
      }
    s.path = new CompoundPath(startt, end-startt);
    double bot = floor-juggler.controls.ballscale;
    if (juggler.controls.manualzoom.getState())
      bot -= 3;
    Point3 startp;
    if (thr.hand == 0) 
      startp = new Point3(-handpattern.handspread-2*handpattern.handswing, 
			  bot, 0.);
    else 
      startp = new Point3(handpattern.handspread+2*handpattern.handswing, 
			  bot, 0.);
    Point3 endp = handpattern.ctchPosAtTime(thr.hand, start, s.thrw.time,true);
    if (juggler.controls.fakeheights.getState())
      s.path.addPath(new Parabola(startp, endp, startt, end-startt,
				  handpattern.height(startp.z)+
				  heightperball*(end-start)));
    else
      s.path.addPath(new Parabola(startp, endp, startt, end-startt,
				  handpattern.height(startp.z)+
				  heightperball*(end-start)*(end-start)));
  }
  
  // tell a ball what to do next
public void updateBall(Ball s)
  {
    Point3 start = s.path.end();

    int curhand = s.thrw.hand;
    int curtime = s.thrw.time;
    s.thrw = juggler.pattern.nextThrw(s.thrw.hand, s.thrw.time);
    if (s.thrw.height >= 0)
      s.label = (new Integer(s.thrw.height)).toString() + 
	        s.thrw.getStr(s.thrw.exp);
    else
      s.label = "d";

    if (s.thrw.height > 0)
      s.path = new CompoundPath(s.path.endtime, s.thrw.height);
    Point3 thrwpos = handpattern.thrwPosAtTime(curhand, curtime, curtime+1, 
					       start.z, 
	                                       (s.thrw.isRev()));
    Point3 ctchpos = handpattern.ctchPosAtTime(s.thrw.hand, curtime, 
					       s.thrw.time, true);
    if (s.thrw.isBou())
      if (s.thrw.height != 1)
	{
	  Point3 middle = new Point3((thrwpos.x+ctchpos.x)/2.,floor,thrwpos.z);
	  s.path.addPath(new Parabola(start, thrwpos, s.path.starttime, 1., 
				      handpattern.dip(start.z)));
	  double h = (s.thrw.height-1)/2.;
	  if (juggler.controls.fakeheights.getState())
	    {
	      s.path.addPath(new Parabola(thrwpos, middle,
					  s.path.starttime+1., h,
					  handpattern.height(start.z)+
					  heightperball*h));
	      s.path.addPath(new Parabola(middle, ctchpos,
					  s.path.starttime+1.+h, h,
					  handpattern.height(start.z)+
					  heightperball*h));
	    }
	  else
	    { 
	      s.path.addPath(new Parabola(thrwpos, middle,
					  s.path.starttime+1., h,
					  handpattern.height(start.z)+
					  heightperball*h*h));
	      s.path.addPath(new Parabola(middle, ctchpos,
					  s.path.starttime+1.+h, h,
					  handpattern.height(start.z)+
					  heightperball*h*h));
	    }
	}
      else
	{
	  Point3 middle = new Point3((start.x+ctchpos.x)/2.,floor,thrwpos.z);
	  s.path.addPath(new Parabola(start, middle,
				      s.path.starttime, .5,
				      handpattern.height(start.z)+.01));
	  s.path.addPath(new Parabola(middle, ctchpos,
				      s.path.starttime+.5, .5,
				      handpattern.height(start.z)+.01));
	}
    else if (s.thrw.isThr() && s.thrw.height != 1 && 
	     s.thrw.height != -1)
      {    // general case throw  
	s.path.addPath(new Parabola(start, thrwpos, s.path.starttime, 1., 
				    handpattern.dip(start.z)));
	if (juggler.controls.fakeheights.getState())
	  s.path.addPath(new Parabola(thrwpos, ctchpos,
				      s.path.starttime+1., s.thrw.height-1,
				      handpattern.height(start.z)+
				      heightperball*(s.thrw.height-1)));
	else
	  s.path.addPath(new Parabola(thrwpos, ctchpos,
				      s.path.starttime+1., s.thrw.height-1,
				      handpattern.height(start.z)+
				      heightperball*(s.thrw.height-1)*
				      (s.thrw.height-1)));
      }
    else if (s.thrw.height == 2)   // non crossing 2
      if (juggler.pattern.shouldHold(curhand)) 
	{    // held 2, not moving
	  s.path.addPath(new Line(start, ctchpos, s.path.starttime, 2.));
	}
      else    // held 2, moving with hand for multiplex
	if (juggler.pattern.oneOnly(curhand))
	  {
	    Point3 newthrwpos = new Point3((start.x+thrwpos.x)/2, 
					   (start.y+thrwpos.y)/2, thrwpos.z);
	    s.path.addPath(new Line(start, newthrwpos, s.path.starttime, .25));
	    s.path.addPath(new Line(newthrwpos, ctchpos, s.path.starttime+.25,
				    1.75));
	  }
	else
	  {
	    s.path.addPath(new Parabola(start, thrwpos, s.path.starttime, 1., 
					handpattern.dip(start.z)));
	    s.path.addPath(new Line(thrwpos, ctchpos, s.path.starttime+1.,1.));
	  }
    else if (s.thrw.height == 1)  // 1s are special
      {
	if (juggler.pattern.oneOnly(curhand))
	  {
	    Point3 newthrwpos = new Point3((start.x+thrwpos.x)/2, 
					   (start.y+thrwpos.y)/2, thrwpos.z);
	    s.path.addPath(new Line(start, newthrwpos, s.path.starttime, .25));
	    s.path.addPath(new Line(newthrwpos, ctchpos, s.path.starttime+.25,
				    .75));
	  }
	else
	  {
	    double dip = handpattern.dip(start.z);
	    Path handpath = new Parabola(start, thrwpos, s.path.starttime, 1.,
					 dip);
	    Point3 newthrwpos = handpath.interpolate(s.path.starttime+.6);
	    s.path.addPath(new Parabola(start, newthrwpos, s.path.starttime, 
					.6, dip));
	    s.path.addPath(new Line(newthrwpos, ctchpos, s.path.starttime+.6,
				    .4));
	  }
      }
    else        // a negative throw means it should disappear! 
      {
	if (DBG) System.out.println("deleting ball");

	double bot = floor - juggler.controls.ballscale-10;
	
	double newendtime;
	if (juggler.controls.fakeheights.getState())
	  newendtime = 2*(1+Math.sqrt(-bot/(heightperball*4.)));
	else
	  newendtime = 2*(1+Math.sqrt(-bot/(heightperball*16.)));

	s.path = new CompoundPath(s.path.endtime, 1+newendtime);
	
	s.path.addPath(new Parabola(start, thrwpos, s.path.starttime, 1., 
				    handpattern.dip(start.z)));
        Point3 end;
        if (curhand == 0) 
	  end = new Point3(-handpattern.handspread-2*handpattern.handswing, bot, 0.);
	else 
	  end = new Point3(handpattern.handspread+2*handpattern.handswing, bot, 0.);
	if (juggler.controls.fakeheights.getState())
	  s.path.addPath(new Parabola(thrwpos, end, s.path.starttime+1., 
				      newendtime, 
				      handpattern.height(start.z)+
				      heightperball*4.));
	else
	  s.path.addPath(new Parabola(thrwpos, end, s.path.starttime+1., 
				      newendtime,
				      handpattern.height(start.z)+
				      heightperball*16.));
        s.lastpath = true;
      }
  }

  
  // tell the hand what to do next
  // The hand is assumed to alway start and end its paths at catch position.
  // If we want to modify things so that the hand stays at throw 
  // position when its next catch is a 1, it needs to peek ahead one
  // throw here and decide whether to take this return path or not
  // the pattern will need a new method to support the peek, and it
  // will have to be careful about multiplexes!!
public void updateHand(Hand s)
  {
    // assume always starting paths from catch position
    int logendtime = juggler.pattern.time;
    Point3 start = handpattern.ctchPosAtTime(s.hand, logendtime, 
					     logendtime, false);  
    s.label = juggler.pattern.getHandLabel(s.hand);
    if (juggler.pattern.handHasZero(s.hand))
      {
	s.zero = true;
	s.path = new CompoundPath(s.path.endtime, 1.);
	Point3 end = handpattern.ctchPosAtTime(s.hand, logendtime, 
					       logendtime+1, false);  
	s.path.addPath(new Line(start, end, s.path.starttime, 1.));
      }
    else if (juggler.pattern.shouldHold(s.hand))  
      {   // 0, 1, or held 2 => stay at catch position
	s.zero = false;
	s.path = new CompoundPath(s.path.endtime, 2.);
	Point3 end = handpattern.ctchPosAtTime(s.hand, logendtime, 
					       logendtime+2, false);  
	s.path.addPath(new Line(start, end, s.path.starttime, 2.));
      }
    else  //  moving for throw
      {
	s.zero = false;
	// path to move to throw postion
	Point3 end = handpattern.thrwPosAtTime(s.hand, logendtime, 
					       logendtime+1, start.z,
				    juggler.pattern.reverseThrow(s.hand));  
	end.z = -1000000000;
	s.path = new CompoundPath(s.path.endtime, 2.);    
	
	if (juggler.pattern.oneOnly(s.hand))
	  {
	    Point3 newthrwpos = new Point3((start.x+end.x)/2, 
					   (start.y+end.y)/2, end.z);
	    s.path.addPath(new Line(start, newthrwpos, s.path.starttime, .25));
	    end = handpattern.ctchPosAtTime(s.hand, logendtime, 
					    logendtime+2, false);  
	    s.path.addPath(new Line(newthrwpos, end, s.path.starttime+.25,
				    1.75));
	  }
	else
	  {
	    s.path.addPath(new Parabola(start, end, s.path.starttime, 
					1., handpattern.dip(start.z)));

	    // path to catch position
	    start = end;
	    end = handpattern.ctchPosAtTime(s.hand, logendtime, 
					    logendtime+2, false);  
	    s.path.addPath(new Line(start, end, s.path.starttime+1, 1.));
	  }
      }
  }

}
