/*
 * @(#)Thrw.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.BitSet;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Thrw.java,v 1.14 1997/03/23 14:49:48 gwar Exp $
 */

////////////////////////////////////////////////////////////////////////
// This just has the basic info about a throw that's used in pattern.
class Thrw
{
  static public int NOBIT=15;
  static public int REV=1;
  static public int THR=2;
  static public int CRO=4;
  static public int BOU=8;

  static public char rev='r';
  static public char thr='t';
  static public char cro='x';
  static public char bou='b';

  public int height;         // throw height
  public int hand;           // throwing hand
  public int time;           // logical time of throw
  public Thrw next;

  public BitSet exp;
  public BitSet imp;
  private String eStr;
  private String iStr;

  public Thrw()
  {
  }
  
  public Thrw(int height, int hand, int time, BitSet explicit, BitSet implicit)
  {
    this.height = height;
    this.hand = hand;
    this.time = time;
    this.next = null;
    this.exp = (BitSet)explicit.clone();
    this.imp = (BitSet)implicit.clone();
    this.eStr = new String(getStr(exp));
    this.iStr = new String(getStr(imp));
  }

  public Thrw(int height, int hand, int time)
  {
    this.height = height;
    this.hand = hand;
    this.time = time;
    this.next = null;
    this.exp = new BitSet(4);
    this.imp = new BitSet(4);
    this.eStr = new String("");
    this.iStr = new String("");
  }

  static public String getStr(BitSet bs)
  {
    StringBuffer strb = new StringBuffer("");
    if(bs.get(REV)) strb.append(rev);
    if(bs.get(THR)) strb.append(thr);
    if(bs.get(CRO)) strb.append(cro);
    if(bs.get(BOU)) strb.append(bou);
    return strb.toString();
  }

  public Thrw copy()
  {
    Thrw ans= new Thrw();
    ans.height = this.height;
    ans.hand = this.hand;
    ans.time = this.time;
    ans.exp = (BitSet)this.exp.clone();
    ans.imp = (BitSet)this.imp.clone();
    ans.eStr = new String(this.eStr);
    ans.iStr = new String(this.iStr);
    ans.next = this.next;
    return ans;
  }

  public void printThrow()
  {
    System.out.print("height: "+height+"   ");
    System.out.print("hand: "+hand+"   ");
    System.out.print("time: "+time+"   ");
    System.out.print("exp: " + eStr);
    System.out.print("    imp: " + iStr);
    System.out.println("  next: "+next);
  }
  

  // takes a vector of throws and picks out the throws for hand
  public static StringBuffer readNames(Vector ths, int hand)
  {
    StringBuffer hd1 = new StringBuffer();
    Thrw th;
    int num = 0;

    for(Enumeration e = ths.elements(); e.hasMoreElements(); )
      {
	th = (Thrw) e.nextElement();
	if(th.hand == hand)
	  {
	    num++;
	    if(th.height == -1)
	      hd1.append('*');
	    else
	      {
		if(th.height <= 9)
		  hd1.append(th.height);
		else
		  hd1.append((char)(th.height + 'A' - 10));
		hd1.append(th.getStr(th.exp));
	      }
	  }
      }

    // this hand is multiplexing
    if(num > 1)
      {
	hd1.insert(0,'[');
	hd1.append(']');
      }

    return hd1;
  }

// a feature that could be added would be to have (an) argument(s)
// listing specific modifiers that should be paid attention to or
// ignored.
 public static boolean sameThrow(Thrw th1, Thrw th2, boolean ignoreMods)
   {
    int i=0;
   
    // ooooooops.
    if(true)
      return false;

    if(th1.height != th2.height)
      return false;

    if(ignoreMods) 
      return true;

//     for(i = 0; i < Math.min(th1.mods.length(), th2.mods.length()); i++)
//     {
//      char ch1 = th1.mods.charAt(i);
//      char ch2 = th2.mods.charAt(i);
//      if(th2.mods.indexOf(ch1) < 0 || th1.mods.indexOf(ch2) < 0)
//        return false;
//     }
   
//     for(i = th1.mods.length(); i < th2.mods.length(); i++)
//       if(th2.mods.indexOf(th1.mods.charAt(i)) < 0)
//         return false;
   
//     for(i = th2.mods.length(); i < th1.mods.length(); i++)
//       if(th1.mods.indexOf(th2.mods.charAt(i)) < 0)
//         return false;
     
    return true;
   }

// assumes there are only two hands.  will also switch the parity
// on a synchronous pattern.
public static void switchParity(Thrw ths[], int len)
  {
    for(int i=0; i < len; i++)
      ths[i].hand = (ths[i].hand + 1)%2;
  }

public boolean isRev()
{
  return (exp.get(REV) || imp.get(REV));
}

public boolean isCro()
{
  return (exp.get(CRO) || imp.get(CRO));
}

public boolean isBou()
{
  return (exp.get(BOU) || imp.get(BOU));
}

public boolean isThr()
{
  return (exp.get(THR) || imp.get(THR));
}

private void resetStr(boolean explicit)
{
  if(explicit)
    eStr = new String(getStr(exp));
  else
    iStr = new String(getStr(imp));
}

public void setRev(boolean explicit)
{
  if(explicit)
    exp.set(REV);
  else
    imp.set(REV);
  resetStr(explicit);
}

public void setCro(boolean explicit)
{
  if(explicit)
    exp.set(CRO);
  else
    imp.set(CRO);
  resetStr(explicit);
}

public void setBou(boolean explicit)
{
  if(explicit)
    exp.set(BOU);
  else
    imp.set(BOU);
  resetStr(explicit);
}

public void setThr(boolean explicit)
{
  if(explicit)
    exp.set(THR);
  else
    imp.set(THR);
  resetStr(explicit);
}

}












