/*
 * @(#)Timer.java	
 *
 * Copyright (c) 1996,7 Allen Knutson, Matthew Levine, Gregory Warrington. 
 * This file is part of [MA][GNU]S.
 * 
 * [MA][GNU]S is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * [MA][GNU]S is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with [MA][GNU]S; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.applet.*;
import java.io.*;
import java.awt.*;

/**
 * @author  Allen Knutson, Matthew Levine, Gregory Warrington
 * @version $Id: Timer.java,v 1.6 1997/03/16 19:36:31 gwar Exp $
 */

////////////////////////////////////////////////////////////////////////
// Timer handles the mapping from real time to logical time
class Timer
{
  long starttime;
  long stoptime;
  double logtimestep;
  boolean stopped;
  
public Timer()
  {
    starttime=0;
    stoptime=0;
    logtimestep=1000;
    stopped = true;
  }

public void start()
  {
    starttime += (System.currentTimeMillis() - stoptime);
    stopped = false;
  }
  
public void stop()
  {
    stoptime = System.currentTimeMillis();
    stopped = true;
  }

  // don't call this until after start() has been called once!
public void setLogicalTimeStep(int step)
  {
    // this is careful to preserve the current logical time while
    // changing its rate
    double lnow = now();
    if (stopped)
      starttime = stoptime-(long)(lnow*step);
    else
      starttime = System.currentTimeMillis()-(long)(lnow*step);
    logtimestep = step;
  }

public double now()
  {
    if (stopped) return (stoptime-starttime)/logtimestep;
    else return (System.currentTimeMillis()-starttime)/logtimestep;
  }
}

